/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyContext;

public class NetSupportSocket
extends SpdyContext.NetSupport {
    private boolean running = true;
    private ServerSocket serverSocket;

    @Override
    public boolean isSpdy(Object socketW) {
        return false;
    }

    @Override
    public SpdyConnection getConnection(String host, int port) throws IOException {
        try {
            Socket sock = this.getSocket(host, port);
            sock.getInputStream();
            SpdyConnectionSocket con = new SpdyConnectionSocket(this.ctx, sock);
            this.ctx.getExecutor().execute(con.inputThread);
            return con;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected Socket getSocket(String host, int port) throws IOException {
        try {
            if (this.ctx.tls) {
                SSLContext sslCtx = SSLContext.getDefault();
                SSLSocket socket = (SSLSocket)sslCtx.getSocketFactory().createSocket(host, port);
                socket.startHandshake();
                return socket;
            }
            return new Socket(host, port);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void stop() throws IOException {
        this.running = false;
        this.serverSocket.close();
    }

    @Override
    public void onAccept(Object socket) {
        SpdyConnectionSocket ch = new SpdyConnectionSocket(this.ctx, (Socket)socket);
        ch.onBlockingSocket();
    }

    @Override
    public void listen(final int port, String cert, String key) throws IOException {
        this.ctx.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                NetSupportSocket.this.accept(port);
            }
        });
    }

    private void accept(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            while (this.running) {
                final Socket socket = this.serverSocket.accept();
                this.ctx.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        NetSupportSocket.this.onAccept(socket);
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (IOException ex) {
            if (this.running) {
                ex.printStackTrace();
            }
            this.running = false;
        }
    }

    private static class SpdyConnectionSocket
    extends SpdyConnection {
        private Socket socket;
        Runnable inputThread = new Runnable(){

            @Override
            public void run() {
                SpdyConnectionSocket.this.onBlockingSocket();
                try {
                    SpdyConnectionSocket.this.inClosed = true;
                    SpdyConnectionSocket.this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };

        public SpdyConnectionSocket(SpdyContext spdyContext) {
            super(spdyContext);
        }

        public SpdyConnectionSocket(SpdyContext spdyContext, Socket socket) {
            super(spdyContext);
            this.socket = socket;
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }

        @Override
        public synchronized int write(byte[] data, int off, int len) throws IOException {
            this.socket.getOutputStream().write(data, off, len);
            return len;
        }

        @Override
        public int read(byte[] data, int off, int len) throws IOException {
            try {
                return this.socket.getInputStream().read(data, off, len);
            }
            catch (SocketTimeoutException ex) {
                return 0;
            }
        }
    }
}

