/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyFrame;
import org.apache.tomcat.spdy.SpdyStream;

public final class SpdyContext {
    public static final byte[] SPDY_NPN = "spdy/2".getBytes();
    public static final byte[] SPDY_NPN_OUT = new byte[SPDY_NPN.length + 2];
    private Executor executor;
    private int defaultFrameSize = 8192;
    public static final boolean debug = false;
    protected boolean tls = true;
    protected boolean compression = true;
    private NetSupport netSupport;
    SpdyHandler handler;

    public void setTlsCompression(boolean tls, boolean compress) {
        this.tls = tls;
        this.compression = compress;
    }

    public SpdyFrame getFrame() {
        return new SpdyFrame(this.defaultFrameSize);
    }

    public void setFrameSize(int frameSize) {
        this.defaultFrameSize = frameSize;
    }

    public SpdyStream getStream(SpdyConnection framer) {
        SpdyStream spdyStream = new SpdyStream(framer);
        return spdyStream;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setNetSupport(NetSupport netSupport) {
        this.netSupport = netSupport;
        netSupport.setSpdyContext(this);
    }

    public NetSupport getNetSupport() {
        if (this.netSupport == null) {
            try {
                Class<?> c0 = Class.forName("org.apache.tomcat.spdy.NetSupportOpenSSL");
                this.netSupport = (NetSupport)c0.newInstance();
                this.netSupport.setSpdyContext(this);
                return this.netSupport;
            }
            catch (Throwable t) {
                try {
                    Class<?> c1 = Class.forName("org.apache.tomcat.spdy.NetSupportJava7");
                    this.netSupport = (NetSupport)c1.newInstance();
                    this.netSupport.setSpdyContext(this);
                    return this.netSupport;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("SSL NextProtoclNegotiation no supported.");
                }
            }
        }
        return this.netSupport;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        return this.executor;
    }

    public SpdyHandler getHandler() {
        return this.handler;
    }

    public void setHandler(SpdyHandler handler) {
        this.handler = handler;
    }

    public SpdyConnection getConnection(String host, int port) throws IOException {
        return this.netSupport.getConnection(host, port);
    }

    public final void listen(int port, String cert, String key) throws IOException {
        this.netSupport.listen(port, cert, key);
    }

    public final void stop() throws IOException {
        this.netSupport.stop();
    }

    public void onStream(SpdyConnection spdyConnection, SpdyStream ch) throws IOException {
        if (this.handler instanceof NonBlockingSpdyHandler) {
            this.handler.onStream(spdyConnection, ch);
        } else {
            this.getExecutor().execute(ch);
        }
    }

    static {
        System.arraycopy(SPDY_NPN, 0, SPDY_NPN_OUT, 1, SPDY_NPN.length);
        SpdyContext.SPDY_NPN_OUT[0] = (byte)SPDY_NPN.length;
    }

    public static interface NonBlockingSpdyHandler
    extends SpdyHandler {
    }

    public static interface SpdyHandler {
        public void onStream(SpdyConnection var1, SpdyStream var2) throws IOException;
    }

    public static abstract class NetSupport {
        protected SpdyContext ctx;

        public void setSpdyContext(SpdyContext ctx) {
            this.ctx = ctx;
        }

        public abstract SpdyConnection getConnection(String var1, int var2) throws IOException;

        public abstract boolean isSpdy(Object var1);

        public abstract void onAccept(Object var1);

        public abstract void listen(int var1, String var2, String var3) throws IOException;

        public abstract void stop() throws IOException;
    }
}

