/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLExt;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.jni.socket.AprSocket;
import org.apache.tomcat.jni.socket.HostInfo;

public class AprSocketContext {
    private static final Logger log = Logger.getLogger("AprSocketCtx");
    private static final int FALLBACK_POLL_TIME = 2000;
    boolean USE_TICKETS = false;
    private final AprSocket END = new AprSocket(this);
    private static final AtomicInteger contextNumber = new AtomicInteger();
    private int contextId;
    private final AtomicInteger threadNumber = new AtomicInteger();
    private AcceptorThread acceptor;
    private AcceptorDispatchThread acceptorDispatch;
    private boolean threadSafe = true;
    private final List<AprPoller> pollers = new ArrayList<AprPoller>();
    boolean tcpNoDelay = true;
    protected boolean running = true;
    protected boolean sslMode;
    private boolean nonBlockingAccept = false;
    private final BlockingQueue<AprSocket> acceptedQueue = new LinkedBlockingQueue<AprSocket>();
    private long rootPool = 0L;
    private volatile long sslCtx = 0L;
    TlsCertVerifier tlsCertVerifier;
    final int connectTimeout = 20000;
    final int defaultTimeout = 100000;
    final int keepAliveTimeout = 20000;
    final AtomicInteger open = new AtomicInteger();
    private int pollTime = 5000000;
    private HostInfoLoader hostInfoLoader;
    final RawDataHandler rawDataHandler = null;
    private final Map<String, HostInfo> hosts = new HashMap<String, HostInfo>();
    private String certFile;
    private String keyFile;
    private byte[] spdyNPN;
    private byte[] ticketKey;
    private ExecutorService threadPool;
    final ExecutorService connectExecutor;
    final boolean debugSSL = false;
    private boolean debugPoll = false;
    private boolean deferAccept = false;
    private int backlog = 100;
    private boolean useSendfile;
    private int sslProtocol = 28;
    final AtomicLong maxHandlerTime = new AtomicLong();
    final AtomicLong totalHandlerTime = new AtomicLong();
    final AtomicLong handlerCount = new AtomicLong();
    private final AtomicInteger connectionsCount = new AtomicInteger();
    private int pollerThreadCount = 4;
    private int maxConnections = 65536;
    private String SSLCipherSuite = "ALL";
    private static IOException noApr;
    private static boolean sizeLogged;

    public AprSocketContext() {
        this.connectExecutor = new ThreadPoolExecutor(0, 64, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                AprSocket s = (AprSocket)r;
                log.severe("Rejecting " + s);
                s.reset();
            }
        });
        this.contextId = contextNumber.incrementAndGet();
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setMaxconnections(int maxCon) {
        this.maxConnections = maxCon;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setNpn(String npn) {
        byte[] data = npn.getBytes();
        byte[] npnB = new byte[data.length + 2];
        System.arraycopy(data, 0, npnB, 1, data.length);
        npnB[0] = (byte)data.length;
        npnB[npnB.length - 1] = 0;
        this.spdyNPN = npnB;
    }

    public void setNpn(byte[] data) {
        this.spdyNPN = data;
    }

    public void setHostLoader(HostInfoLoader handler) {
        this.hostInfoLoader = handler;
    }

    public boolean isServer() {
        return this.acceptor != null;
    }

    protected Executor getExecutor() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "AprThread-" + AprSocketContext.this.contextId + "-" + AprSocketContext.this.threadNumber.incrementAndGet());
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.threadPool;
    }

    public AprSocketContext setTls() {
        this.sslMode = true;
        return this;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public void setSslProtocol(String protocol) {
        if ("SSLv2".equalsIgnoreCase(protocol = protocol.trim())) {
            this.sslProtocol = 1;
        } else if ("SSLv3".equalsIgnoreCase(protocol)) {
            this.sslProtocol = 2;
        } else if ("TLSv1".equalsIgnoreCase(protocol)) {
            this.sslProtocol = 4;
        } else if ("TLSv1.1".equalsIgnoreCase(protocol)) {
            this.sslProtocol = 8;
        } else if ("TLSv1.2".equalsIgnoreCase(protocol)) {
            this.sslProtocol = 16;
        } else if ("all".equalsIgnoreCase(protocol)) {
            this.sslProtocol = 28;
        }
    }

    public void setTicketKey(byte[] key48Bytes) {
        if (key48Bytes.length != 48) {
            throw new RuntimeException("Key must be 48 bytes");
        }
        this.ticketKey = key48Bytes;
    }

    public void customVerification(TlsCertVerifier verifier) {
        this.tlsCertVerifier = verifier;
    }

    public AprSocketContext setKeys(String certPemFile, String keyDerFile) {
        this.sslMode = true;
        this.setTls();
        this.certFile = certPemFile;
        this.keyFile = keyDerFile;
        return this;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public HostInfo getHostInfo(String host, int port, boolean ssl) {
        if (this.hostInfoLoader != null) {
            return this.hostInfoLoader.getHostInfo(host, port, ssl);
        }
        String key = host + ":" + port;
        HostInfo pi = this.hosts.get(key);
        if (pi != null) {
            return pi;
        }
        pi = new HostInfo(host, port, ssl);
        this.hosts.put(key, pi);
        return pi;
    }

    protected void rawData(AprSocket ch, boolean inp, byte[] data, int pos, int len, int requested, boolean closed) {
        if (this.rawDataHandler != null) {
            this.rawDataHandler.rawData(ch, inp, data, pos, len, requested, closed);
        }
    }

    public void listen(int port) throws IOException {
        if (this.acceptor != null) {
            throw new IOException("Already accepting on " + this.acceptor.port);
        }
        if (this.sslMode && this.certFile == null) {
            throw new IOException("Missing certificates for server");
        }
        if (this.sslMode || !this.nonBlockingAccept) {
            this.acceptorDispatch = new AcceptorDispatchThread();
            this.acceptorDispatch.setName("AprAcceptorDispatch-" + port);
            this.acceptorDispatch.start();
        }
        this.acceptor = new AcceptorThread(port);
        this.acceptor.prepare();
        this.acceptor.setName("AprAcceptor-" + port);
        this.acceptor.start();
    }

    public AprSocket socket(String host, int port, boolean ssl) {
        HostInfo hi = this.getHostInfo(host, port, ssl);
        return this.socket(hi);
    }

    public AprSocket socket(HostInfo hi) {
        AprSocket sock = this.newSocket(this);
        sock.setHost(hi);
        return sock;
    }

    public AprSocket socket(long socket) {
        AprSocket sock = this.newSocket(this);
        SSLExt.sslSetMode(socket, 3L);
        sock.setStatus(512);
        sock.socket = socket;
        return sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySocket(AprSocket socket) {
        AprSocket aprSocket = socket;
        synchronized (aprSocket) {
            if (socket.socket != 0L) {
                long s = socket.socket;
                socket.socket = 0L;
                log.info("DESTROY: " + Long.toHexString(s));
                Socket.destroy(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectBlocking(AprSocket apr) throws IOException {
        try {
            long clientSockP;
            if (!this.running) {
                throw new IOException("Stopped");
            }
            HostInfo hi = apr.getHost();
            List<AprPoller> list = this.pollers;
            synchronized (list) {
                long socketpool = Pool.create(this.getRootPool());
                int family = 1;
                clientSockP = Socket.create(family, 0, 6, socketpool);
            }
            Socket.timeoutSet(clientSockP, 20000000L);
            if (OS.IS_UNIX) {
                Socket.optSet(clientSockP, 16, 1);
            }
            Socket.optSet(clientSockP, 2, 1);
            long inetAddress = Address.info(hi.host, 1, hi.port, 0, this.rootPool);
            int rc = Socket.connect(clientSockP, inetAddress);
            if (rc != 0) {
                List<AprPoller> list2 = this.pollers;
                synchronized (list2) {
                    Socket.close(clientSockP);
                    Socket.destroy(clientSockP);
                }
                throw new IOException("Socket.connect(): " + rc + " " + Error.strerror(rc) + " " + 20000);
            }
            if (!this.running) {
                throw new IOException("Stopped");
            }
            this.connectionsCount.incrementAndGet();
            if (this.tcpNoDelay) {
                Socket.optSet(clientSockP, 512, 1);
            }
            Socket.timeoutSet(clientSockP, 100000000L);
            apr.socket = clientSockP;
            apr.afterConnect();
        }
        catch (IOException e) {
            apr.reset();
            throw e;
        }
        catch (Throwable e) {
            apr.reset();
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    AprSocket newSocket(AprSocketContext context) {
        return new AprSocket(context);
    }

    protected void finalize() throws Throwable {
        if (this.rootPool != 0L) {
            log.warning(this + " GC without stop()");
            try {
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<AprPoller> list = this.pollers;
        synchronized (list) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        if (this.rootPool != 0L) {
            if (this.acceptor != null) {
                try {
                    this.acceptor.unblock();
                    this.acceptor.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.acceptorDispatch != null) {
                this.acceptedQueue.add(this.END);
                try {
                    this.acceptorDispatch.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
            log.info("Stopping pollers " + this.contextId);
            while (true) {
                AprPoller a;
                List<AprPoller> list2 = this.pollers;
                synchronized (list2) {
                    if (this.pollers.size() == 0) {
                        break;
                    }
                    a = this.pollers.remove(0);
                }
                a.interruptPoll();
                try {
                    a.join();
                    log.info("Poller " + a.id + " done ");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        List<AprPoller> list = this.pollers;
        synchronized (list) {
            if (this.pollers.size() != 0) {
                return;
            }
            if (this.rootPool == 0L) {
                return;
            }
            log.info("Destroy root pool " + this.rootPool);
        }
    }

    private long getRootPool() throws IOException {
        if (this.rootPool == 0L) {
            if (noApr != null) {
                throw noApr;
            }
            this.rootPool = Pool.create(0L);
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.maxConnections > 1024) {
                this.pollerThreadCount = this.maxConnections / 1024;
                this.maxConnections -= this.maxConnections % 1024;
            }
        }
        return this.rootPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getSslCtx() throws Exception {
        if (this.sslCtx != 0L) return this.sslCtx;
        Class<AprSocketContext> clazz = AprSocketContext.class;
        synchronized (AprSocketContext.class) {
            if (this.sslCtx != 0L) return this.sslCtx;
            boolean serverMode = this.acceptor != null;
            this.sslCtx = SSLContext.make(this.getRootPool(), this.sslProtocol, serverMode ? 1 : 0);
            int opts = 0x1100000;
            if (!this.USE_TICKETS || serverMode && this.ticketKey == null) {
                opts |= 0x4000;
            }
            SSLContext.setOptions(this.sslCtx, opts);
            try {
                SSLContext.setCipherSuite(this.sslCtx, this.SSLCipherSuite);
                if (serverMode) {
                    boolean rc;
                    if (this.ticketKey != null) {
                        // empty if block
                    }
                    if (this.certFile != null && !(rc = SSLContext.setCertificate(this.sslCtx, this.certFile, this.keyFile, null, 1))) {
                        throw new IOException("Can't set keys");
                    }
                    SSLContext.setVerify(this.sslCtx, 0, 10);
                    if (this.spdyNPN == null) return this.sslCtx;
                    SSLExt.setNPN(this.sslCtx, this.spdyNPN, this.spdyNPN.length);
                } else {
                    if (this.tlsCertVerifier != null) {
                        SSLContext.setVerify(this.sslCtx, 0, 10);
                    } else {
                        SSLContext.setCACertificate(this.sslCtx, "/etc/ssl/certs/ca-certificates.crt", "/etc/ssl/certs");
                        SSLContext.setVerify(this.sslCtx, 2, 10);
                    }
                    if (this.spdyNPN == null) return this.sslCtx;
                    SSLExt.setNPN(this.sslCtx, this.spdyNPN, this.spdyNPN.length);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return this.sslCtx;
        }
    }

    void findPollerAndAdd(AprSocket ch) throws IOException {
        if (ch.poller != null) {
            ch.poller.requestUpdate(ch);
            return;
        }
        this.assignPoller(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignPoller(AprSocket ch) throws IOException {
        AprPoller target = null;
        List<AprPoller> list = this.pollers;
        synchronized (list) {
            int needPollers = this.pollerThreadCount - this.pollers.size();
            if (needPollers > 0) {
                for (int i = needPollers; i > 0; --i) {
                    this.pollers.add(this.allocatePoller());
                }
            }
            int max = 0;
            for (AprPoller poller : this.pollers) {
                int rem = poller.remaining();
                if (rem <= max) continue;
                target = poller;
                max = rem;
            }
        }
        if (target != null && target.add(ch)) {
            return;
        }
        list = this.pollers;
        synchronized (list) {
            AprPoller poller = this.allocatePoller();
            poller.add(ch);
            this.pollers.add(poller);
        }
    }

    protected void onSocket(AprSocket s) {
    }

    AprPoller allocatePoller() throws IOException {
        int size = this.maxConnections / this.pollerThreadCount;
        long pool = Pool.create(this.getRootPool());
        long serverPollset = this.allocatePoller(size, pool);
        if (serverPollset == 0L && size > 1024) {
            log.severe("Falling back to 1024-sized poll, won't scale");
            size = 1024;
            serverPollset = this.allocatePoller(size, pool);
        }
        if (serverPollset == 0L) {
            log.severe("Falling back to 62-sized poll, won't scale");
            size = 62;
            serverPollset = this.allocatePoller(size, pool);
        }
        AprPoller res = new AprPoller();
        res.pool = pool;
        res.serverPollset = serverPollset;
        AprPoller.access$1502(res, new long[size * 2]);
        res.size = size;
        res.id = this.contextId++;
        res.setDaemon(true);
        res.setName("AprPoller-" + res.id);
        res.start();
        if (this.debugPoll && !sizeLogged) {
            sizeLogged = true;
            log.info("Poller size " + res.desc.length / 2);
        }
        return res;
    }

    protected long allocatePoller(int size, long pool) {
        int flag = this.threadSafe ? 1 : 0;
        for (int i = 0; i < 2; ++i) {
            try {
                return Poll.create(size, pool, flag, -1L);
            }
            catch (Error e) {
                e.printStackTrace();
                if (Status.APR_STATUS_IS_EINVAL(e.getError())) {
                    log.info(" endpoint.poll.limitedpollsize " + size);
                    return 0L;
                }
                if (!Status.APR_STATUS_IS_ENOTIMPL(e.getError())) {
                    log.severe("endpoint.poll.initfail" + e);
                    return 0L;
                }
                log.severe("THREAD SAFE NOT SUPPORTED" + e);
                this.threadSafe = false;
                continue;
            }
        }
        log.severe("Unexpected ENOTIMPL with flag==0");
        return 0L;
    }

    static {
        try {
            Library.initialize(null);
            SSL.initialize(null);
        }
        catch (Exception e) {
            noApr = new IOException("APR not present", e);
        }
        sizeLogged = false;
    }

    public static interface NonBlockingPollHandler
    extends BlockingPollHandler {
        public void connected(AprSocket var1);

        public void error(AprSocket var1, Throwable var2);
    }

    public static interface BlockingPollHandler {
        public void process(AprSocket var1, boolean var2, boolean var3, boolean var4);

        public void closed(AprSocket var1);
    }

    class AprPoller
    extends Thread {
        private int id;
        private int size;
        private long serverPollset = 0L;
        private long pool = 0L;
        private long[] desc;
        private long lastPoll;
        private long lastPollTime;
        private final AtomicBoolean inPoll = new AtomicBoolean(false);
        private final Map<Long, AprSocket> channels = new HashMap<Long, AprSocket>();
        private final AtomicInteger keepAliveCount = new AtomicInteger();
        private final AtomicInteger polledCount = new AtomicInteger();
        private final AtomicInteger pollCount = new AtomicInteger();
        private final List<AprSocket> updates = new ArrayList<AprSocket>();

        AprPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AprSocketContext.this.running) {
                return;
            }
            if (AprSocketContext.this.debugPoll) {
                log.info("Starting poller " + this.id + " " + (AprSocketContext.this.isServer() ? "SRV " : "CLI "));
            }
            long t0 = System.currentTimeMillis();
            while (AprSocketContext.this.running) {
                try {
                    int errn;
                    this.updates();
                    AprPoller aprPoller = this;
                    synchronized (aprPoller) {
                        this.inPoll.set(true);
                    }
                    int rv = Poll.poll(this.serverPollset, AprSocketContext.this.pollTime, this.desc, true);
                    AprPoller aprPoller2 = this;
                    synchronized (aprPoller2) {
                        this.inPoll.set(false);
                        if (!AprSocketContext.this.running) {
                            break;
                        }
                    }
                    this.pollCount.incrementAndGet();
                    this.lastPoll = System.currentTimeMillis();
                    this.lastPollTime = this.lastPoll - t0;
                    if (rv > 0) {
                        if (AprSocketContext.this.debugPoll) {
                            log.info(" Poll() id=" + this.id + " rv=" + rv + " keepAliveCount=" + this.keepAliveCount + " polled = " + this.polledCount.get() + " time=" + this.lastPollTime);
                        }
                        this.polledCount.addAndGet(-rv);
                        for (int pollIdx = 0; pollIdx < rv; ++pollIdx) {
                            boolean in;
                            boolean nval;
                            AprSocket ch;
                            long sock = this.desc[pollIdx * 2 + 1];
                            boolean blocking = false;
                            Map<Long, AprSocket> map = this.channels;
                            synchronized (map) {
                                ch = this.channels.get(sock);
                                if (ch == null) {
                                    log.severe("Polled socket not found !!!!!" + Long.toHexString(sock));
                                    continue;
                                }
                                blocking = ch.isBlocking();
                            }
                            ch.clearStatus(16);
                            long mask = this.desc[pollIdx * 2];
                            boolean err = (mask & 0x10L) == 16L;
                            boolean bl = nval = (mask & 0x40L) != 0L;
                            if (err || nval) {
                                System.err.println("ERR " + err + " NVAL " + nval);
                            }
                            boolean out = (mask & 4L) == 4L;
                            boolean bl2 = in = (mask & 1L) == 1L;
                            if (AprSocketContext.this.debugPoll) {
                                log.info(" Poll channel: " + Long.toHexString(mask) + (out ? " OUT" : "") + (in ? " IN" : "") + (err ? " ERR" : "") + " Ch: " + ch);
                            }
                            ch.clearStatus(256);
                            ch.clearStatus(128);
                            if (blocking) {
                                AprSocket aprSocket = ch;
                                synchronized (aprSocket) {
                                    ch.notifyAll();
                                }
                                AprSocketContext.this.getExecutor().execute(ch);
                                continue;
                            }
                            ((NonBlockingPollHandler)ch.handler).process(ch, in, out, false);
                            this.updateIOThread(ch);
                        }
                        continue;
                    }
                    if (rv >= 0 || (errn = -rv) == 120001 || errn == 120003) continue;
                    if (AprSocketContext.this.debugPoll) {
                        log.info(" Poll() rv=" + rv + " keepAliveCount=" + this.keepAliveCount + " polled = " + this.polledCount.get() + " time=" + this.lastPollTime);
                    }
                    if (errn > 120000) {
                        errn -= 120000;
                    }
                    log.severe("endpoint.poll.fail " + errn + " " + Error.strerror(errn));
                    AprPoller aprPoller3 = this;
                    synchronized (aprPoller3) {
                        this.destroyPoller();
                    }
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "endpoint.poll.error", t);
                }
            }
            if (!AprSocketContext.this.running) {
                this.destroyPoller();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroyPoller() {
            Object object = AprSocketContext.this.pollers;
            synchronized (object) {
                AprSocketContext.this.pollers.remove(this);
            }
            log.info("Poller stopped after cnt=" + this.pollCount.get() + " sockets=" + this.channels.size() + " lastPoll=" + this.lastPoll);
            object = this;
            synchronized (object) {
                if (this.serverPollset == 0L) {
                    return;
                }
                this.keepAliveCount.set(0);
                log.warning("Destroy pollset");
            }
            Pool.destroy(this.pool);
            this.pool = 0L;
            object = AprSocketContext.this.pollers;
            synchronized (object) {
                if (AprSocketContext.this.pollers.size() == 0 && !AprSocketContext.this.running) {
                    log.info("Destroy server context");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updates() throws IOException {
            AprPoller aprPoller = this;
            synchronized (aprPoller) {
                for (AprSocket up : this.updates) {
                    this.updateIOThread(up);
                }
                this.updates.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptPoll() {
            block8: {
                try {
                    int rc = 0;
                    AprPoller aprPoller = this;
                    synchronized (aprPoller) {
                        if (this.serverPollset != 0L) {
                            rc = Poll.interrupt(this.serverPollset);
                        } else {
                            log.severe("Interrupt with closed pollset");
                        }
                    }
                    if (rc != 0) {
                        log.severe("Failed interrupt and not thread safe");
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (AprSocketContext.this.pollTime <= 2000) break block8;
                    AprSocketContext.this.pollTime = 2000;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int remaining() {
            Map<Long, AprSocket> map = this.channels;
            synchronized (map) {
                return this.desc.length - this.channels.size() * 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(AprSocket ch) throws IOException {
            AprPoller aprPoller = this;
            synchronized (aprPoller) {
                if (!AprSocketContext.this.running) {
                    return false;
                }
                if (this.keepAliveCount.get() >= this.size) {
                    return false;
                }
                this.keepAliveCount.incrementAndGet();
                ch.poller = this;
            }
            this.requestUpdate(ch);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void requestUpdate(AprSocket ch) throws IOException {
            AprPoller aprPoller = this;
            synchronized (aprPoller) {
                if (!AprSocketContext.this.running) {
                    return;
                }
            }
            if (this.isPollerThread()) {
                this.updateIOThread(ch);
            } else {
                aprPoller = this;
                synchronized (aprPoller) {
                    if (!this.updates.contains(ch)) {
                        this.updates.add(ch);
                    }
                    this.interruptPoll();
                }
                if (AprSocketContext.this.debugPoll) {
                    log.info("Poll: requestUpdate " + this.id + " " + ch);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateIOThread(AprSocket ch) throws IOException {
            if (!AprSocketContext.this.running || ch.socket == 0L) {
                return;
            }
            boolean polling = ch.checkPreConnect(16);
            int requested = ch.requestedPolling();
            if (requested == 0) {
                if (polling) {
                    this.removeSafe(ch);
                }
                if (ch.isClosed()) {
                    Map<Long, AprSocket> map = this.channels;
                    synchronized (map) {
                        ch.poller = null;
                        this.channels.remove(ch.socket);
                    }
                    this.keepAliveCount.decrementAndGet();
                    ch.reset();
                }
            } else {
                if (polling) {
                    this.removeSafe(ch);
                }
                this.pollAdd(ch, requested);
            }
            if (AprSocketContext.this.debugPoll) {
                log.info("Poll: updated=" + this.id + " " + ch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollAdd(AprSocket up, int req) throws IOException {
            int rv;
            boolean failed = false;
            Map<Long, AprSocket> map = this.channels;
            synchronized (map) {
                if (up.isClosed()) {
                    return;
                }
                rv = Poll.add(this.serverPollset, up.socket, req);
                if (rv != 0) {
                    up.poller = null;
                    this.keepAliveCount.decrementAndGet();
                    failed = true;
                } else {
                    this.polledCount.incrementAndGet();
                    this.channels.put(up.socket, up);
                    up.setStatus(16);
                }
            }
            if (failed) {
                up.reset();
                throw new IOException("poll add error " + rv + " " + up + " " + Error.strerror(rv));
            }
        }

        private void removeSafe(AprSocket up) {
            int rv = 20014;
            if (AprSocketContext.this.running && this.serverPollset != 0L && up.socket != 0L && !up.isClosed()) {
                rv = Poll.remove(this.serverPollset, up.socket);
            }
            up.clearStatus(16);
            if (rv != 0) {
                log.severe("poll remove error " + Error.strerror(rv) + " " + up);
            } else {
                this.polledCount.decrementAndGet();
            }
        }

        public boolean isPollerThread() {
            return Thread.currentThread() == this;
        }

        static /* synthetic */ long[] access$1502(AprPoller x0, long[] x1) {
            x0.desc = x1;
            return x1;
        }
    }

    private class AcceptorDispatchThread
    extends Thread {
        AcceptorDispatchThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (AprSocketContext.this.running) {
                try {
                    AprSocket ch = (AprSocket)AprSocketContext.this.acceptedQueue.take();
                    if (ch == AprSocketContext.this.END) {
                        return;
                    }
                    AprSocketContext.this.connectExecutor.execute(ch);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class AcceptorThread
    extends Thread {
        private final int port;
        private long serverSockPool = 0L;
        private long serverSock = 0L;
        private long inetAddress;

        AcceptorThread(int port) {
            this.port = port;
            this.setDaemon(true);
        }

        void prepare() throws IOException {
            try {
                this.serverSockPool = Pool.create(AprSocketContext.this.getRootPool());
                int family = 1;
                this.inetAddress = Address.info(null, family, this.port, 0, this.serverSockPool);
                this.serverSock = Socket.create(family, 0, 6, this.serverSockPool);
                if (OS.IS_UNIX) {
                    Socket.optSet(this.serverSock, 16, 1);
                }
                Socket.optSet(this.serverSock, 2, 1);
                int ret = Socket.bind(this.serverSock, this.inetAddress);
                if (ret != 0) {
                    throw new IOException("Socket.bind " + ret + " " + Error.strerror(ret) + " port=" + this.port);
                }
                ret = Socket.listen(this.serverSock, AprSocketContext.this.backlog);
                if (ret != 0) {
                    throw new IOException("endpoint.init.listen" + ret + " " + Error.strerror(ret));
                }
                if (OS.IS_WIN32 || OS.IS_WIN64) {
                    Socket.optSet(this.serverSock, 16, 1);
                }
                if (AprSocketContext.this.useSendfile && !Library.APR_HAS_SENDFILE) {
                    AprSocketContext.this.useSendfile = false;
                }
                if (AprSocketContext.this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
                    AprSocketContext.this.deferAccept = false;
                }
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }

        void unblock() {
            try (java.net.Socket sock = new java.net.Socket();){
                sock.connect(new InetSocketAddress("127.0.0.1", this.port));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (AprSocketContext.this.running) {
                try {
                    AprSocket ch = AprSocketContext.this.newSocket(AprSocketContext.this);
                    ch.setStatus(512);
                    ch.socket = Socket.accept(this.serverSock);
                    if (!AprSocketContext.this.running) break;
                    AprSocketContext.this.connectionsCount.incrementAndGet();
                    if (AprSocketContext.this.connectionsCount.get() % 1000 == 0) {
                        System.err.println("Accepted: " + AprSocketContext.this.connectionsCount.get());
                    }
                    if (AprSocketContext.this.nonBlockingAccept && !AprSocketContext.this.sslMode) {
                        ch.setStatus(2);
                        AprSocketContext.this.onSocket(ch);
                        continue;
                    }
                    AprSocketContext.this.acceptedQueue.add(ch);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            Socket.close(this.serverSock);
        }
    }

    public static interface HostInfoLoader {
        public HostInfo getHostInfo(String var1, int var2, boolean var3);
    }

    public static interface TlsCertVerifier {
        public void handshakeDone(AprSocket var1);
    }

    public static interface RawDataHandler {
        public void rawData(AprSocket var1, boolean var2, byte[] var3, int var4, int var5, int var6, boolean var7);
    }
}

