/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.util.net.DispatchType;

public class SocketWrapper<E> {
    private volatile E socket;
    private volatile long lastAccess = System.currentTimeMillis();
    private volatile long timeout = -1L;
    private boolean error = false;
    private volatile int keepAliveLeft = 100;
    private volatile boolean comet = false;
    private volatile boolean async = false;
    private boolean keptAlive = false;
    private volatile boolean upgraded = false;
    private boolean secure = false;
    private String localAddr = null;
    private String localName = null;
    private int localPort = -1;
    private String remoteAddr = null;
    private String remoteHost = null;
    private int remotePort = -1;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    private final Object writeThreadLock = new Object();
    private Set<DispatchType> dispatches = new CopyOnWriteArraySet<DispatchType>();

    public SocketWrapper(E socket) {
        this.socket = socket;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = lock.readLock();
        this.blockingStatusWriteLock = lock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean comet) {
        this.comet = comet;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void access() {
        if (!this.isAsync()) {
            this.access(System.currentTimeMillis());
        }
    }

    public void access(long access) {
        this.lastAccess = access;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean keptAlive) {
        this.keptAlive = keptAlive;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean blockingStatus) {
        this.blockingStatus = blockingStatus;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }

    public Object getWriteThreadLock() {
        return this.writeThreadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatch(DispatchType dispatchType) {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.add(dispatchType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DispatchType> getIteratorAndClearDispatches() {
        Iterator<DispatchType> result;
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            result = this.dispatches.iterator();
            if (result.hasNext()) {
                this.dispatches.clear();
            } else {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDispatches() {
        Set<DispatchType> set = this.dispatches;
        synchronized (set) {
            this.dispatches.clear();
        }
    }

    public void reset(E socket, long timeout) {
        this.async = false;
        this.blockingStatus = true;
        this.comet = false;
        this.dispatches.clear();
        this.error = false;
        this.keepAliveLeft = 100;
        this.lastAccess = System.currentTimeMillis();
        this.localAddr = null;
        this.localName = null;
        this.localPort = -1;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.socket = socket;
        this.timeout = timeout;
        this.upgraded = false;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }
}

