/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Arrays;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.core.RSAPrivateKey;

public class OraclePKIRSAPrivateKey
implements RSAPrivateCrtKey {
    private final RSAPrivateKey a;
    private final CertificateRequest b;

    OraclePKIRSAPrivateKey(RSAPrivateKey rSAPrivateKey, CertificateRequest certificateRequest) {
        this.a = rSAPrivateKey;
        this.b = certificateRequest;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.a.getPrimeP();
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.a.getPrimeQ();
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.a.getPrimeExponentP();
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.a.getPrimeExponentQ();
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.a.getCrtCoefficient();
    }

    @Override
    public BigInteger getModulus() {
        return this.a.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.a.getPublicExponent();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.a.getExponent();
    }

    @Override
    public String getAlgorithm() {
        if (this.a != null) {
            return this.a.getAlgorithm();
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return this.a.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.a.getEncoded();
    }

    public CertificateRequest getCertificateRequest() {
        return this.b;
    }

    public boolean isPvtKeyPresent() {
        return this.a != null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object instanceof OraclePKIRSAPrivateKey) {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((OraclePKIRSAPrivateKey)object).getEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        return false;
    }
}

