/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.ssl.OracleSSLDebug;
import oracle.security.pki.ssl.OracleSSLX509TrustManager;

final class OracleSSLX509CertTrustManagerImpl
implements OracleSSLX509TrustManager {
    Vector a = new Vector();
    static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    OracleSSLX509CertTrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        Vector vector = new Vector(keyStore.size());
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            if (keyStore.getCertificate(string) instanceof OraclePKIX509CertImpl) {
                this.a.add(keyStore.getCertificate(string));
                OracleSSLDebug.a("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            if (!(keyStore.getCertificate(string) instanceof X509Certificate)) continue;
            try {
                X509 x509 = new X509(((X509Certificate)keyStore.getCertificate(string)).getEncoded());
                this.a.addElement(new OraclePKIX509CertImpl(x509));
                OracleSSLDebug.a("OracleX509CertTrustManager: added trusted cert at alias " + string);
            }
            catch (Exception exception) {
                OracleSSLDebug.a("OracleX509TrutManagaer: Invalid cert at alias " + string);
            }
        }
        OracleSSLDebug.a("OracleX509CertTrustManager: Trust Manager Created");
    }

    private final OraclePKIX509CertImpl a(X509Certificate x509Certificate) {
        OracleSSLDebug.a("OracleX509CertTrustManager: Looking for trusted certificate: " + x509Certificate.getSubjectDN());
        for (int i = 0; i < this.a.size(); ++i) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.a.elementAt(i);
            OracleSSLDebug.a("OracleX509CertTrustManager: Is it : " + oraclePKIX509CertImpl + " ? " + x509Certificate.getIssuerDN().equals(oraclePKIX509CertImpl.getSubjectDN()));
            if (!x509Certificate.getIssuerDN().equals(oraclePKIX509CertImpl.getSubjectDN())) continue;
            boolean bl = false;
            try {
                X509 x509 = new X509(x509Certificate.getEncoded());
                x509.setIssuerCertificate(oraclePKIX509CertImpl.getX509());
                bl = x509.verifyCertSignature();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) continue;
            return oraclePKIX509CertImpl;
        }
        return null;
    }

    @Override
    public final void a(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        int n;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException(b.getString("PKI-07004"));
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        boolean bl = false;
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>();
        try {
            vector.addElement(new OraclePKIX509CertImpl(new X509(x509CertificateArray[0].getEncoded())));
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(0);
            block4: for (int i = 1; i < x509CertificateArray.length; ++i) {
                oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(i - 1);
                OracleSSLDebug.a("OracleX509CertTrustManager: Looking for signer of:  " + oraclePKIX509CertImpl.getSubjectDN());
                OraclePKIX509CertImpl oraclePKIX509CertImpl2 = this.a(oraclePKIX509CertImpl);
                if (oraclePKIX509CertImpl2 != null) {
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl2.getX509());
                    bl = true;
                    break;
                }
                for (int j = 1; j < x509CertificateArray.length; ++j) {
                    OracleSSLDebug.a("OracleX509CertTrustManager: Is it : " + x509CertificateArray[j].getSubjectDN() + " ? " + oraclePKIX509CertImpl.getIssuerDN().equals(x509CertificateArray[j].getSubjectDN()));
                    if (!oraclePKIX509CertImpl.getIssuerDN().equals(x509CertificateArray[j].getSubjectDN())) continue;
                    X509 x509 = new X509(x509CertificateArray[j].getEncoded());
                    oraclePKIX509CertImpl.getX509().setIssuerCertificate(x509);
                    vector.addElement(new OraclePKIX509CertImpl(x509));
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            throw new CertificateException("Invalid certificate in chain");
        }
        oraclePKIX509CertImpl = (OraclePKIX509CertImpl)vector.elementAt(vector.size() - 1);
        OracleSSLDebug.a("OracleX509CertTrustManager: Trying to complete the chain ending with: " + oraclePKIX509CertImpl.getIssuerDN());
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = this.a(oraclePKIX509CertImpl);
        if (oraclePKIX509CertImpl3 != null) {
            oraclePKIX509CertImpl.getX509().setIssuerCertificate(oraclePKIX509CertImpl3.getX509());
            vector.addElement(oraclePKIX509CertImpl3);
            bl = true;
        }
        if (!bl) {
            throw new CertificateException(b.getString("PKI-07005"));
        }
        oraclePKIX509CertImplArray = vector.toArray(new OraclePKIX509CertImpl[vector.size()]);
        OracleSSLDebug.a("Checking Dates of Certificates");
        for (n = 0; n < oraclePKIX509CertImplArray.length - 1; ++n) {
            x509CertificateArray[n].checkValidity();
        }
        OracleSSLDebug.a("Checking Usage of Certificates");
        if (!OraclePKIX509CertUsage.isCertChainValidFor(x509CertificateArray, 1)) {
            OracleSSLDebug.a("Peer is not trusted");
            throw new CertificateException("Peer is not trusted");
        }
        OracleSSLDebug.a("Checking Signatures");
        try {
            for (n = 0; n < oraclePKIX509CertImplArray.length - 1; ++n) {
                oraclePKIX509CertImplArray[n].getX509().verifyCertSignature();
            }
        }
        catch (AuthenticationException authenticationException) {
            OracleSSLDebug.a("   " + authenticationException.getMessage());
            OracleSSLDebug.a("Invalid signature");
            throw new CertificateException(b.getString("PKI-07006"));
        }
        OracleSSLDebug.a("Certificate Chain OK");
    }

    @Override
    public final void b(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.a(x509CertificateArray);
    }

    @Override
    public final X509Certificate[] a() {
        return this.a.toArray(new X509Certificate[this.a.size()]);
    }
}

