/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLReasonExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLReason;
    private CRLReason reason = null;

    public CRLReasonExtension() {
        super(TYPE);
    }

    public CRLReasonExtension(CRLReason reason) {
        this(reason, false);
    }

    public CRLReasonExtension(CRLReason reason, boolean critical) {
        super(TYPE, critical);
        this.reason = reason;
        this.setValue(this.toByteArray());
    }

    public CRLReasonExtension(InputStream is) throws IOException {
        super(is);
    }

    public CRLReason getReason() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.reason;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)this.reason);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.reason = new CRLReason((InputStream)new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLReasonExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", reason = " + this.getReason() + "}";
    }
}

