/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.Synchronization;
import org.apache.servicemix.camel.nmr.ServiceMixEndpoint;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.service.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixConsumer
extends DefaultConsumer
implements Endpoint,
Synchronization {
    private Channel channel;

    public ServiceMixConsumer(ServiceMixEndpoint endpoint, Processor processor) {
        super((org.apache.camel.Endpoint)endpoint, processor);
    }

    public ServiceMixEndpoint getEndpoint() {
        return (ServiceMixEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().getComponent().registerEndpoint(this, this.createEndpointMap());
    }

    protected void doStop() throws Exception {
        this.getEndpoint().getComponent().unregisterEndpoint(this, this.createEndpointMap());
        super.doStop();
    }

    private Map<String, ?> createEndpointMap() {
        Map result = ServiceHelper.createMap((String[])new String[]{"NAME", this.getEndpoint().getEndpointName()});
        result.put("CHANNEL_SYNC_DELIVERY", this.getEndpoint().isSynchronous());
        result.put("RUN_AS_SUBJECT", this.getEndpoint().isRunAsSubject());
        return result;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void process(Exchange exchange) {
        if (exchange.getStatus() == Status.Active) {
            try {
                org.apache.camel.Exchange camelExchange = this.getEndpoint().createExchange(exchange);
                camelExchange.addOnCompletion((Synchronization)this);
                this.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                    }
                });
            }
            catch (Exception e) {
                exchange.setError(e);
                exchange.setStatus(Status.Error);
                this.channel.send(exchange);
            }
        }
    }

    private void handleCamelResponse(Exchange exchange, org.apache.camel.Exchange camelExchange) {
        exchange.getProperties().putAll(camelExchange.getProperties());
        if (camelExchange.getException() != null) {
            exchange.setError(camelExchange.getException());
            exchange.setStatus(Status.Error);
        } else if (camelExchange.hasOut() && !camelExchange.getOut().isFault()) {
            this.getEndpoint().getComponent().getBinding().copyCamelMessageToNmrMessage(exchange.getOut(), camelExchange.getOut());
        } else if (camelExchange.hasOut() && camelExchange.getOut().isFault()) {
            this.getEndpoint().getComponent().getBinding().copyCamelMessageToNmrMessage(exchange.getFault(), camelExchange.getOut());
        } else {
            exchange.setStatus(Status.Done);
        }
        this.channel.send(exchange);
    }

    public void onComplete(org.apache.camel.Exchange exchange) {
        Exchange nmr = this.getEndpoint().getComponent().getBinding().extractNmrExchange(exchange);
        this.handleCamelResponse(nmr, exchange);
    }

    public void onFailure(org.apache.camel.Exchange exchange) {
        Exchange nmr = this.getEndpoint().getComponent().getBinding().extractNmrExchange(exchange);
        this.handleCamelResponse(nmr, exchange);
    }
}

