/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ServiceMixConsumer;
import org.apache.servicemix.camel.nmr.ServiceMixProducer;
import org.apache.servicemix.nmr.api.Exchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixEndpoint
extends DefaultEndpoint {
    private static final String SYNCHRONOUS = "synchronous";
    public static final String RUN_AS_SUBJECT = "runAsSubject";
    private static final String TIMEOUT = "timeout";
    private static final Long DEFAULT_TIMEOUT = new Long(0L);
    private String endpointName;
    private boolean synchronous;
    private boolean runAsSubject;
    private Long timeOut = DEFAULT_TIMEOUT;

    public ServiceMixEndpoint(ServiceMixComponent component, String uri, String endpointName) {
        super(uri, (Component)component);
        this.endpointName = endpointName;
    }

    public void configureProperties(Map<String, Object> options) {
        this.synchronous = Boolean.valueOf((String)options.remove(SYNCHRONOUS));
        this.runAsSubject = Boolean.valueOf((String)options.remove(RUN_AS_SUBJECT));
        this.timeOut = this.parseLongOption(options, TIMEOUT);
    }

    private Long parseLongOption(Map<String, Object> options, String timeout) {
        String value = (String)options.remove(TIMEOUT);
        if (value != null) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    public ServiceMixComponent getComponent() {
        return (ServiceMixComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isRunAsSubject() {
        return this.runAsSubject;
    }

    public Long getTimeOut() {
        return this.timeOut;
    }

    public Producer createProducer() throws Exception {
        return new ServiceMixProducer(this, this.getComponent().getNmr());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ServiceMixConsumer(this, processor);
    }

    public org.apache.camel.Exchange createExchange(Exchange nmrExchange) {
        return this.getComponent().getBinding().populateCamelExchangeFromNmrExchange(this.getCamelContext(), nmrExchange);
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }
}

