/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.BooleanGetExecutor;
import org.apache.commons.jexl2.internal.DuckGetExecutor;
import org.apache.commons.jexl2.internal.DuckSetExecutor;
import org.apache.commons.jexl2.internal.ListGetExecutor;
import org.apache.commons.jexl2.internal.ListSetExecutor;
import org.apache.commons.jexl2.internal.MapGetExecutor;
import org.apache.commons.jexl2.internal.MapSetExecutor;
import org.apache.commons.jexl2.internal.MethodExecutor;
import org.apache.commons.jexl2.internal.PropertyGetExecutor;
import org.apache.commons.jexl2.internal.PropertySetExecutor;
import org.apache.commons.jexl2.internal.introspection.IntrospectorBase;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    protected final Log rlog;
    private volatile SoftReference<IntrospectorBase> ref;

    protected Introspector(Log log) {
        this.rlog = log;
        this.ref = new SoftReference<Object>(null);
    }

    protected Integer toInteger(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Number) {
            return ((Number)arg).intValue();
        }
        try {
            return Integer.valueOf(arg.toString());
        }
        catch (NumberFormatException xnumber) {
            return null;
        }
    }

    protected String toString(Object arg) {
        return arg == null ? null : arg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IntrospectorBase base() {
        IntrospectorBase intro = this.ref.get();
        if (intro == null) {
            Introspector introspector = this;
            synchronized (introspector) {
                intro = this.ref.get();
                if (intro == null) {
                    intro = new IntrospectorBase(this.rlog);
                    this.ref = new SoftReference<IntrospectorBase>(intro);
                }
            }
        }
        return intro;
    }

    public void setClassLoader(ClassLoader loader) {
        this.base().setLoader(loader);
    }

    protected final Field getField(Class<?> c, String key) {
        return this.base().getField(c, key);
    }

    public final String[] getFieldNames(Class<?> c) {
        return this.base().getFieldNames(c);
    }

    protected final Method getMethod(Class<?> c, String name, Object[] params) throws IllegalArgumentException {
        return this.base().getMethod(c, new MethodKey(name, params));
    }

    protected final Method getMethod(Class<?> c, MethodKey key) throws IllegalArgumentException {
        return this.base().getMethod(c, key);
    }

    public final String[] getMethodNames(Class<?> c) {
        return this.base().getMethodNames(c);
    }

    public final Constructor<?> getConstructor(Object ctorHandle, Object[] args) {
        String className = null;
        Class clazz = null;
        if (ctorHandle instanceof Class) {
            clazz = (Class)ctorHandle;
            className = clazz.getName();
        } else if (ctorHandle != null) {
            className = ctorHandle.toString();
        } else {
            return null;
        }
        return this.base().getConstructor(clazz, new MethodKey(className, args));
    }

    public final AbstractExecutor.Method getMethodExecutor(Object obj, String name, Object[] args) {
        MethodExecutor me = new MethodExecutor(this, obj, name, args);
        return me.isAlive() ? me : null;
    }

    public final AbstractExecutor.Get getGetExecutor(Object obj, Object identifier) {
        AbstractExecutor.Get executor;
        Class<?> claz = obj.getClass();
        String property = this.toString(identifier);
        if (property != null && (executor = new PropertyGetExecutor(this, claz, property)).isAlive()) {
            return executor;
        }
        if (property != null && (executor = new BooleanGetExecutor(this, claz, property)).isAlive()) {
            return executor;
        }
        executor = new MapGetExecutor(this, claz, identifier);
        if (executor.isAlive()) {
            return executor;
        }
        Integer index = this.toInteger(identifier);
        if (index != null && (executor = new ListGetExecutor(this, claz, index)).isAlive()) {
            return executor;
        }
        executor = new DuckGetExecutor(this, claz, identifier);
        if (executor.isAlive()) {
            return executor;
        }
        return null;
    }

    public final AbstractExecutor.Set getSetExecutor(Object obj, Object identifier, Object arg) {
        AbstractExecutor.Set executor;
        Class<?> claz = obj.getClass();
        String property = this.toString(identifier);
        if (property != null && (executor = new PropertySetExecutor(this, claz, property, arg)).isAlive()) {
            return executor;
        }
        executor = new MapSetExecutor(this, claz, identifier, arg);
        if (executor.isAlive()) {
            return executor;
        }
        Integer index = this.toInteger(identifier);
        if (index != null && (executor = new ListSetExecutor(this, claz, index, arg)).isAlive()) {
            return executor;
        }
        executor = new DuckSetExecutor(this, claz, property, arg);
        if (executor.isAlive()) {
            return executor;
        }
        return null;
    }
}

