/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.common.locks.LockManager;
import org.apache.servicemix.common.locks.impl.SimpleLockManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePollerEndpoint
extends PollingEndpoint
implements FileEndpointType {
    private File file;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean autoCreateDirectory = true;
    private File archive;
    private Comparator<File> comparator;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;
    private ConcurrentMap<String, InputStream> openExchanges = new ConcurrentHashMap<String, InputStream>();
    private int maxConcurrent = -1;
    private Object monitor = new Object();
    private AtomicLong throttleCounter = new AtomicLong(0L);

    public FilePollerEndpoint() {
    }

    public FilePollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public FilePollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public synchronized void start() throws Exception {
        super.start();
        this.openExchanges = new ConcurrentHashMap<String, InputStream>();
    }

    public void poll() throws Exception {
        if (!this.isThrottled()) {
            this.pollFileOrDirectory(this.file);
        } else {
            logger.info("Poller is throttled, skipping this cycle");
        }
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.file == null) {
            throw new DeploymentException("You must specify a file property");
        }
        if (this.isAutoCreateDirectory() && !this.file.exists()) {
            this.file.mkdirs();
        }
        if (this.archive != null) {
            if (!this.deleteFile) {
                throw new DeploymentException("Archive shouldn't be specified unless deleteFile='true'");
            }
            if (this.isAutoCreateDirectory() && !this.archive.exists()) {
                this.archive.mkdirs();
            }
            if (!this.archive.isDirectory()) {
                throw new DeploymentException("Archive should refer to a directory");
            }
        }
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public void setMaxConcurrent(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public File getArchive() {
        return this.archive;
    }

    protected void pollFileOrDirectory(File fileOrDirectory) {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            logger.debug("Polling directory {}", (Object)fileOrDirectory);
            File[] files = this.sortPolledFiles(fileOrDirectory.listFiles(this.getFilter()));
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            logger.debug("Skipping directory {}", (Object)fileOrDirectory);
        }
    }

    private File[] sortPolledFiles(File[] files) {
        if (this.comparator == null) {
            return files;
        }
        Arrays.sort(files, this.comparator);
        return files;
    }

    protected void pollFile(final File aFile) {
        logger.debug("Scheduling file {} for processing", (Object)aFile);
        if (!FileUtil.isFileFullyAvailable((File)aFile)) {
            logger.debug("The file {} is still being copied. Skipping...", (Object)aFile);
            return;
        }
        this.checkThrottle();
        this.getExecutor().execute(new Runnable(){

            public void run() {
                String uri = FilePollerEndpoint.this.file.toURI().relativize(aFile.toURI()).toString();
                Lock lock = FilePollerEndpoint.this.lockManager.getLock(uri);
                if (lock.tryLock()) {
                    FilePollerEndpoint.this.processFileNow(aFile);
                } else {
                    logger.debug("Unable to acquire lock on {}", (Object)aFile);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThrottle() {
        if (this.maxConcurrent > 0 && this.openExchanges.size() >= this.maxConcurrent) {
            this.throttleCounter.addAndGet(1L);
            Object object = this.monitor;
            synchronized (object) {
                boolean interrupt = false;
                while (this.openExchanges.size() >= this.maxConcurrent) {
                    if (interrupt) {
                        throw new IllegalStateException("Throttle block has been interrupted");
                    }
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        interrupt = true;
                    }
                }
            }
            this.throttleCounter.decrementAndGet();
        }
    }

    protected boolean isThrottled() {
        return this.throttleCounter.get() > 0L;
    }

    protected void processFileNow(File aFile) {
        try {
            logger.debug("Processing file {}", (Object)aFile);
            if (aFile.exists()) {
                this.processFile(aFile);
            }
        }
        catch (Exception e) {
            logger.error("Failed to process file: {}", (Object)aFile, (Object)e);
            this.unlockAsyncFile(aFile);
        }
    }

    protected void processFile(File file) throws Exception {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, (InputStream)stream, file.getCanonicalPath());
        exchange.getInMessage().setProperty("org.apache.servicemix.file", (Object)file);
        this.openExchanges.put(exchange.getExchangeId(), stream);
        this.send((MessageExchange)exchange);
    }

    public String getLocationURI() {
        return this.file.toURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        File aFile;
        if (this.openExchanges.containsKey(exchange.getExchangeId())) {
            InputStream stream = (InputStream)this.openExchanges.get(exchange.getExchangeId());
            aFile = (File)exchange.getMessage("in").getProperty("org.apache.servicemix.file");
            if (aFile == null) {
                throw new JBIException("Property org.apache.servicemix.file was removed from the exchange -- unable to delete/archive the file");
            }
            logger.debug("Releasing {}", (Object)aFile.getAbsolutePath());
            stream.close();
            try {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (this.isDeleteFile()) {
                        if (this.archive != null) {
                            FilePollerEndpoint.moveFile(aFile, this.archive);
                        } else if (!aFile.delete()) {
                            throw new IOException("Could not delete file " + aFile);
                        }
                    }
                } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    Exception e = exchange.getError();
                    if (e == null) {
                        throw new JBIException("Received an exchange with status ERROR, but no exception was set");
                    }
                    logger.warn("Message in file {} could not be handled successfully.", (Object)aFile, (Object)e);
                } else {
                    throw new JBIException("Unexpectedly received an exchange with status ACTIVE");
                }
                Object var6_5 = null;
                this.notifyThrottledThreads();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.notifyThrottledThreads();
                this.openExchanges.remove(exchange.getExchangeId());
                this.unlockAsyncFile(aFile);
                throw throwable;
            }
        } else {
            logger.debug("Received unknown exchange. Will be ignored...");
            return;
        }
        this.openExchanges.remove(exchange.getExchangeId());
        this.unlockAsyncFile(aFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThrottledThreads() {
        if (this.maxConcurrent > 0) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    private void unlockAsyncFile(File file) {
        String uri = this.file.toURI().relativize(file.toURI()).toString();
        Lock lock = this.lockManager.getLock(uri);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            this.lockManager.removeLock(uri);
        }
    }

    public static void moveFile(File src, File targetDirectory) throws IOException {
        String targetName = src.getName();
        File target = new File(targetDirectory, targetName);
        if (target.exists() && target.isFile()) {
            targetName = String.format("%d_%s", System.currentTimeMillis(), src.getName());
        }
        if (!src.renameTo(new File(targetDirectory, targetName))) {
            throw new IOException("Failed to move " + src + " to " + targetDirectory + " with new name " + targetName);
        }
    }
}

