/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.validator;

import org.opensaml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffiliationDescriptorSchemaValidator
implements Validator<AffiliationDescriptor> {
    @Override
    public void validate(AffiliationDescriptor affiliationDescriptor) throws ValidationException {
        this.validateOwner(affiliationDescriptor);
        this.validateMember(affiliationDescriptor);
    }

    protected void validateOwner(AffiliationDescriptor affiliationDescriptor) throws ValidationException {
        if (DatatypeHelper.isEmpty(affiliationDescriptor.getOwnerID())) {
            throw new ValidationException("Owner ID required.");
        }
        if (affiliationDescriptor.getOwnerID().length() > 1024) {
            throw new ValidationException("Max Owner ID length is 1024.");
        }
    }

    protected void validateMember(AffiliationDescriptor affiliationDescriptor) throws ValidationException {
        if (affiliationDescriptor.getMembers() == null || affiliationDescriptor.getMembers().size() < 1) {
            throw new ValidationException("Must have one or more Affiliation Members.");
        }
    }
}

