/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.xacml.impl.AbstractXACMLObjectMarshaller;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AttributeValueTypeMarshaller
extends AbstractXACMLObjectMarshaller {
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
        AttributeValueType attributeValue = (AttributeValueType)xmlObject;
        if (!DatatypeHelper.isEmpty(attributeValue.getDataType())) {
            domElement.setAttributeNS(null, "DataType", attributeValue.getDataType());
        }
        for (Map.Entry<QName, String> entry : attributeValue.getUnknownAttributes().entrySet()) {
            Attr attribute = XMLHelper.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attribute.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute(entry.getKey()) && !attributeValue.getUnknownAttributes().isIDAttribute(entry.getKey())) continue;
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }

    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        AttributeValueType attributeValue = (AttributeValueType)xmlObject;
        if (attributeValue.getValue() != null) {
            XMLHelper.appendTextContent(domElement, attributeValue.getValue());
        }
    }
}

