/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;

public class CamelContextEndpoint
extends ProviderEndpoint {
    public static final QName SERVICE_NAME = new QName("http://camel.apache.org/schema/jbi", "camelcontext");
    private final CamelContext camelContext;

    public CamelContextEndpoint(CamelContext camelContext, String su) {
        this.camelContext = camelContext;
        this.setService(SERVICE_NAME);
        this.setEndpoint(su + "-controlbus");
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                this.fail(exchange, new UnsupportedOperationException("No control bus operations available"));
            }
        } else {
            throw new MessagingException("Unexpected exchange role: CamelContextEndpoint is not capable of handling " + exchange.getRole());
        }
    }

    public void start() throws Exception {
        super.start();
        this.camelContext.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.camelContext.stop();
    }
}

