/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.URISupport;
import org.apache.servicemix.camel.CamelConsumerEndpoint;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiComponent;
import org.apache.servicemix.camel.JbiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JbiEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private String destinationUri;
    private String mep;
    private QName operation;
    private boolean convertExceptions;
    private String serialization;
    private HeaderFilterStrategy headerFilterStrategy;
    private final JbiComponent jbiComponent;
    private final JbiBinding binding;

    public JbiEndpoint(JbiComponent jbiComponent, String uri) {
        super(uri, (Component)jbiComponent);
        this.jbiComponent = jbiComponent;
        this.parseUri(uri);
        this.binding = this.createBinding();
    }

    public JbiBinding createBinding() {
        JbiBinding result = new JbiBinding(this.getCamelContext(), this.serialization);
        result.setConvertExceptions(this.convertExceptions);
        result.addHeaderFilterStrategy(this.headerFilterStrategy);
        return result;
    }

    public Producer createProducer() throws Exception {
        return new JbiProducer((Endpoint)this);
    }

    private void parseUri(String uri) {
        this.destinationUri = uri;
        try {
            int idx = this.destinationUri.indexOf(63);
            if (idx > 0) {
                String serialization;
                String convert;
                String oper;
                Map params = URISupport.parseQuery((String)this.destinationUri.substring(idx + 1));
                this.mep = (String)params.get("mep");
                if (this.mep != null && !this.mep.startsWith("http://www.w3.org/ns/wsdl/")) {
                    this.mep = "http://www.w3.org/ns/wsdl/" + this.mep;
                    params.remove("mep");
                }
                if (StringUtils.hasLength((String)(oper = (String)params.get("operation")))) {
                    this.operation = QName.valueOf(oper);
                    params.remove("operation");
                }
                this.destinationUri = this.destinationUri.substring(0, idx);
                String filter = (String)params.get("headerFilterStrategy");
                if (StringUtils.hasLength((String)filter)) {
                    Object object;
                    Registry registry = this.jbiComponent.getCamelContext().getRegistry();
                    if (filter.indexOf(35) != -1) {
                        filter = filter.substring(1);
                    }
                    if ((object = registry.lookup(filter)) instanceof HeaderFilterStrategy) {
                        this.headerFilterStrategy = (HeaderFilterStrategy)object;
                    }
                    params.remove("headerFilterStrategy");
                }
                if (StringUtils.hasLength((String)(convert = (String)params.get("convertExceptions")))) {
                    this.setConvertExceptions(Boolean.valueOf(convert));
                    params.remove("convertExceptions");
                }
                if (StringUtils.hasLength((String)(serialization = (String)params.get("serialization")))) {
                    this.setSerialization(serialization);
                    params.remove("serialization");
                }
                String endpointUri = this.destinationUri + URISupport.createQueryString((Map)params);
                this.setEndpointUri(endpointUri);
            }
        }
        catch (URISyntaxException e) {
            throw new JbiException(e);
        }
    }

    public void setMep(String str) {
        this.mep = str;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public void setDestionationUri(String str) {
        this.destinationUri = str;
    }

    public String getMep() {
        return this.mep;
    }

    public QName getOperation() {
        return this.operation;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public Consumer createConsumer(final Processor processor) throws Exception {
        return new DefaultConsumer((Endpoint)this, processor){
            private CamelProviderEndpoint jbiEndpoint;

            protected void doStart() throws Exception {
                super.doStart();
                this.jbiEndpoint = JbiEndpoint.this.jbiComponent.createJbiEndpointFromCamel((Endpoint)JbiEndpoint.this, AsyncProcessorTypeConverter.convert((Processor)processor));
                JbiEndpoint.this.jbiComponent.getCamelJbiComponent().activateJbiEndpoint(this.jbiEndpoint);
            }

            protected void doStop() throws Exception {
                if (this.jbiEndpoint != null) {
                    JbiEndpoint.this.jbiComponent.getCamelJbiComponent().deactivateJbiEndpoint(this.jbiEndpoint);
                }
                super.doStop();
            }
        };
    }

    public boolean isSingleton() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public void setConvertExceptions(boolean convertExceptions) {
        this.convertExceptions = convertExceptions;
    }

    public boolean isConvertExceptions() {
        return this.convertExceptions;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public String getSerialization() {
        return this.serialization;
    }

    protected class JbiProducer
    extends DefaultProducer
    implements AsyncProcessor {
        private final Logger logger;
        private CamelConsumerEndpoint consumer;

        public JbiProducer(Endpoint exchangeEndpoint) {
            super(exchangeEndpoint);
            this.logger = LoggerFactory.getLogger(JbiProducer.class);
        }

        public void start() throws Exception {
            this.consumer = new CamelConsumerEndpoint(JbiEndpoint.this.binding, JbiEndpoint.this);
            JbiEndpoint.this.jbiComponent.getCamelJbiComponent().addEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
            super.start();
        }

        public void stop() throws Exception {
            if (this.isStopped()) {
                this.logger.debug("Camel producer for " + super.getEndpoint() + " has already been stopped");
            } else {
                this.logger.debug("Stopping Camel producer for " + super.getEndpoint());
                JbiEndpoint.this.jbiComponent.getCamelJbiComponent().removeEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
                super.stop();
            }
        }

        public void process(final Exchange exchange) throws Exception {
            JbiEndpoint.this.binding.runWithCamelContextClassLoader(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    JbiProducer.this.consumer.process(exchange);
                    return null;
                }
            });
        }

        protected CamelConsumerEndpoint getCamelConsumerEndpoint() {
            return this.consumer;
        }

        public boolean process(final Exchange exchange, final AsyncCallback asyncCallback) {
            try {
                return JbiEndpoint.this.binding.runWithCamelContextClassLoader(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return JbiProducer.this.consumer.process(exchange, asyncCallback);
                    }
                });
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                return true;
            }
        }
    }
}

