/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.http.endpoints.AbstractHttpProviderMarshaler;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.api.model.Binding;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapProviderMarshaler
extends AbstractHttpProviderMarshaler
implements HttpProviderMarshaler {
    private Binding<?> binding;
    private boolean useJbiWrapper = true;
    private Policy[] policies;
    private String baseUrl;
    private Map<InterceptorProvider.Phase, InterceptorChain> chains = new HashMap<InterceptorProvider.Phase, InterceptorChain>();
    private String soapVersion = "1.2";

    public Binding<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Binding<?> binding) {
        this.binding = binding;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public void createRequest(MessageExchange exchange, NormalizedMessage inMsg, SmxHttpExchange httpExchange) throws Exception {
        if (this.getContentEncoding() != null) {
            httpExchange.setRequestHeader("Content-Encoding", this.getContentEncoding());
        }
        if (this.getAcceptEncoding() != null) {
            httpExchange.setRequestHeader("Accept-Encoding", this.getAcceptEncoding());
        }
        if (this.soapVersion.equals("1.1")) {
            httpExchange.setRequestContentType("text/xml");
        } else {
            httpExchange.setRequestContentType("application/soap+xml");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream encodingStream = this.getRequestEncodingStream(this.getContentEncoding(), baos);
        Message msg = this.binding.createMessage();
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)inMsg);
        msg.setContent(OutputStream.class, (Object)encodingStream);
        exchange.setProperty(Message.class.getName(), (Object)msg);
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientOut);
        phaseOut.doIntercept(msg);
        encodingStream.close();
        httpExchange.setMethod("POST");
        httpExchange.setURL(this.baseUrl);
        httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
        for (Map.Entry entry : msg.getTransportHeaders().entrySet()) {
            if (this.isBlackListed((String)entry.getKey())) continue;
            httpExchange.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void handleResponse(MessageExchange exchange, SmxHttpExchange httpExchange) throws Exception {
        Message req = (Message)exchange.getProperty(Message.class.getName());
        exchange.setProperty(Message.class.getName(), null);
        Message msg = this.binding.createMessage(req);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(InputStream.class, (Object)this.getResponseEncodingStream(httpExchange.getResponseFields().getStringField("Content-Encoding"), httpExchange.getResponseStream()));
        msg.put((Object)"Encoding", (Object)httpExchange.getResponseEncoding());
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientIn);
        phaseOut.doIntercept(msg);
    }

    @Override
    public void handleException(MessageExchange exchange, SmxHttpExchange httpExchange, Throwable ex) {
        exchange.setError((Exception)ex);
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase) {
        InterceptorChain chain = this.chains.get(phase);
        if (chain == null) {
            chain = this.binding.getInterceptorChain(phase);
            if (this.policies != null) {
                for (int i = 0; i < this.policies.length; ++i) {
                    chain.add((Iterable)this.policies[i].getInterceptors(phase));
                }
            }
            this.chains.put(phase, chain);
        }
        return chain;
    }
}

