/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.ws.addressing;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.tools.wsdl.PortTypeDecorator;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.interceptors.wsdl.WsdlOperationInInterceptor;
import org.apache.servicemix.soap.ws.addressing.AbstractWsAddressingInterceptor;
import org.apache.servicemix.soap.ws.addressing.WsAddressingPolicy;
import org.apache.servicemix.soap.wsdl.BindingFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsAddressingInOperationInterceptor
extends AbstractWsAddressingInterceptor {
    public WsAddressingInOperationInterceptor(WsAddressingPolicy policy, boolean server) {
        super(policy, server);
        this.addBefore(WsdlOperationInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        QName itf = null;
        QName op = null;
        QName svc = null;
        String ep = null;
        String nsUri = null;
        for (QName qname : message.getSoapHeaders().keySet()) {
            String[] parts;
            if (!this.isWSANamespace(qname.getNamespaceURI())) continue;
            if (nsUri == null) {
                nsUri = qname.getNamespaceURI();
            } else if (!nsUri.equals(qname.getNamespaceURI())) {
                throw new SoapFault(SoapFault.SENDER, "Inconsistent use of wsa namespaces");
            }
            if ("Action".equals(qname.getLocalPart())) {
                String action = this.getHeaderText(message.getSoapHeaders().get(qname));
                parts = URIResolver.split3((String)action);
                itf = new QName(parts[0], parts[1]);
                op = new QName(parts[0], parts[2]);
                continue;
            }
            if (!"To".equals(qname.getLocalPart())) continue;
            String to = this.getHeaderText(message.getSoapHeaders().get(qname));
            parts = URIResolver.split3((String)to);
            svc = new QName(parts[0], parts[1]);
            ep = parts[2];
        }
        if (svc != null && ep != null) {
            try {
                ComponentContext ctx = message.get(ComponentContext.class);
                ServiceEndpoint se = ctx.getEndpoint(svc, ep);
                Document doc = ctx.getEndpointDescriptor(se);
                Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, doc);
                Service wsdlSvc = def.getService(svc);
                if (wsdlSvc == null && def.getServices().size() == 0 && def.getPortTypes().size() == 1) {
                    PortType portType = (PortType)def.getPortTypes().values().iterator().next();
                    Definition newDef = PortTypeDecorator.createImportDef((Definition)def, (String)svc.getNamespaceURI(), (String)"urn:import");
                    PortTypeDecorator.decorate((Definition)newDef, (PortType)portType, (String)("jbi:" + svc.toString() + ":" + ep), (String)(portType.getQName().getLocalPart() + "JBI"), (String)svc.getLocalPart(), (String)ep, (String)"1.1");
                    wsdlSvc = newDef.getService(svc);
                }
                Port wsdlPort = wsdlSvc.getPort(ep);
                Binding<?> b = BindingFactory.createBinding(wsdlPort);
                message.put(Binding.class, b);
                message.put(ServiceEndpoint.class, se);
            }
            catch (Exception e) {
                throw new SoapFault(e);
            }
        }
        if (itf != null && op != null) {
            Binding binding = message.get(Binding.class);
            ArrayList<Operation> matching = new ArrayList<Operation>();
            for (Operation operation : binding.getOperations()) {
                if (!operation.getName().equals(op)) continue;
                matching.add(operation);
            }
            if (matching.size() == 1) {
                Operation operation = (Operation)matching.get(0);
                message.put(Operation.class, operation);
                message.put(org.apache.servicemix.soap.api.model.Message.class, this.isServer() ? operation.getOutput() : operation.getInput());
            }
        }
    }

    @Override
    public Collection<URI> getRoles() {
        return Collections.emptyList();
    }

    @Override
    public Collection<QName> getUnderstoodHeaders() {
        ArrayList<QName> h = new ArrayList<QName>();
        h.add(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "To"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "To"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "To"));
        h.add(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        h.add(new QName("http://www.w3.org/2005/08/addressing", "To"));
        return h;
    }
}

