/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.wsdl;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.servicemix.soap.api.model.wsdl2.Wsdl2Message;
import org.apache.servicemix.soap.bindings.http.impl.Wsdl2HttpBindingImpl;
import org.apache.servicemix.soap.bindings.http.impl.Wsdl2HttpHeaderImpl;
import org.apache.servicemix.soap.bindings.http.impl.Wsdl2HttpMessageImpl;
import org.apache.servicemix.soap.bindings.http.impl.Wsdl2HttpOperationImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.extensions.ComponentExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.xml.XMLAttr;
import org.apache.ws.commons.schema.XmlSchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl2BindingFactory {
    public static URI HTTP_BINDING_TYPE = URI.create("http://www.w3.org/2006/01/wsdl/http");
    public static URI XSD_2001_SYSTEM = URI.create("http://www.w3.org/2001/XMLSchema");

    public static org.apache.servicemix.soap.api.model.Binding<?> createBinding(Endpoint wsdlEndpoint) {
        if (HTTP_BINDING_TYPE.equals(wsdlEndpoint.getBinding().getType())) {
            return Wsdl2BindingFactory.createWsdl2HttpBinding(wsdlEndpoint);
        }
        return null;
    }

    private static org.apache.servicemix.soap.api.model.Binding<?> createWsdl2HttpBinding(Endpoint wsdlEndpoint) {
        Wsdl2HttpBindingImpl binding = new Wsdl2HttpBindingImpl();
        binding.setLocation(wsdlEndpoint.getAddress().toString());
        Interface wsdlInterface = wsdlEndpoint.getBinding().getInterface();
        binding.setInterfaceName(wsdlInterface.getName());
        InterfaceOperation[] wsdlOperations = wsdlInterface.getInterfaceOperations();
        for (int i = 0; i < wsdlOperations.length; ++i) {
            InterfaceOperation wsdlOperation = wsdlOperations[i];
            BindingOperation wsdlBindingOperation = Wsdl2BindingFactory.findBindingOperation(wsdlEndpoint.getBinding(), wsdlOperation);
            HTTPBindingOperationExtensions opExt = wsdlBindingOperation != null ? (HTTPBindingOperationExtensions)wsdlBindingOperation.getComponentExtensionsForNamespace(ComponentExtensions.URI_NS_HTTP) : null;
            Wsdl2HttpOperationImpl operation = new Wsdl2HttpOperationImpl();
            operation.setName(wsdlOperation.getName());
            operation.setMep(wsdlOperation.getMessageExchangePattern());
            operation.setStyle(new HashSet<URI>(Arrays.asList(wsdlOperation.getStyle())));
            if (opExt != null) {
                operation.setHttpInputSerialization(opExt.getHttpInputSerialization());
                operation.setHttpOutputSerialization(opExt.getHttpOutputSerialization());
                operation.setHttpFaultSerialization(opExt.getHttpFaultSerialization());
                operation.setHttpLocation(Wsdl2BindingFactory.extractLocation(wsdlBindingOperation));
                operation.setHttpMethod(opExt.getHttpMethod());
                operation.setHttpTransferCodingDefault(opExt.getHttpTransferCodingDefault());
                operation.setHttpLocationIgnoreUncited(opExt.isHttpLocationIgnoreUncited());
            }
            InterfaceMessageReference[] iMsgRefs = wsdlOperation.getInterfaceMessageReferences();
            for (int j = 0; j < iMsgRefs.length; ++j) {
                InterfaceMessageReference iMsgRef = iMsgRefs[j];
                BindingMessageReference bMsgRef = Wsdl2BindingFactory.findBindingMessage(wsdlBindingOperation, iMsgRef);
                HTTPBindingMessageReferenceExtensions msgExt = bMsgRef != null ? (HTTPBindingMessageReferenceExtensions)bMsgRef.getComponentExtensionsForNamespace(ComponentExtensions.URI_NS_HTTP) : null;
                Wsdl2HttpMessageImpl message = new Wsdl2HttpMessageImpl();
                message.setContentModel(Wsdl2Message.ContentModel.parse(iMsgRef.getMessageContentModel()));
                message.setElementName(iMsgRef.getElementDeclaration().getName());
                if (!XSD_2001_SYSTEM.equals(iMsgRef.getElementDeclaration().getSystem())) {
                    throw new IllegalStateException("Unsupported type system: " + iMsgRef.getElementDeclaration().getSystem());
                }
                if ("org.apache.ws.commons.schema".equals(iMsgRef.getElementDeclaration().getContentModel())) {
                    XmlSchemaElement xsEl = (XmlSchemaElement)iMsgRef.getElementDeclaration().getContent();
                    message.setElementDeclaration(xsEl);
                }
                if (msgExt != null) {
                    message.setHttpTransferCoding(msgExt.getHttpTransferCoding());
                    HTTPHeader[] headers = msgExt.getHttpHeaders();
                    for (int k = 0; k < headers.length; ++k) {
                        Wsdl2HttpHeaderImpl h = new Wsdl2HttpHeaderImpl();
                        h.setName(headers[k].getName());
                        h.setRequired(headers[k].isRequired() != false ? headers[k].isRequired() : false);
                        if (!XSD_2001_SYSTEM.equals(headers[k].getTypeDefinition().getSystem())) {
                            throw new IllegalStateException("Unsupported type system: " + headers[k].getTypeDefinition().getSystem());
                        }
                        h.setType(headers[k].getTypeDefinition().getName());
                        message.addHttpHeader(h);
                    }
                }
                if (iMsgRef.getDirection() == Direction.IN) {
                    operation.setInput(message);
                    continue;
                }
                if (iMsgRef.getDirection() == Direction.OUT) {
                    operation.setOutput(message);
                    continue;
                }
                throw new IllegalStateException("Unsupported message direction: " + iMsgRef.getDirection());
            }
            InterfaceFaultReference[] faults = wsdlOperation.getInterfaceFaultReferences();
            for (int j = 0; j < faults.length; ++j) {
            }
            binding.addOperation(operation);
        }
        InterfaceFault[] faults = wsdlInterface.getInterfaceFaults();
        for (int i = 0; i < faults.length; ++i) {
        }
        return binding;
    }

    private static BindingMessageReference findBindingMessage(BindingOperation wsdlBindingOperation, InterfaceMessageReference iMsgRef) {
        BindingMessageReference[] bMsgRefs = wsdlBindingOperation.getBindingMessageReferences();
        for (int i = 0; i < bMsgRefs.length; ++i) {
            if (bMsgRefs[i].getInterfaceMessageReference() != iMsgRef) continue;
            return bMsgRefs[i];
        }
        return null;
    }

    private static BindingOperation findBindingOperation(Binding binding, InterfaceOperation operation) {
        BindingOperation[] bindingOps = binding.getBindingOperations();
        for (int i = 0; i < bindingOps.length; ++i) {
            if (bindingOps[i].getInterfaceOperation() != operation) continue;
            return bindingOps[i];
        }
        return null;
    }

    private static String extractLocation(BindingOperation bOperation) {
        XMLAttr attr;
        String location = null;
        if (bOperation != null && (attr = bOperation.toElement().getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION)) != null) {
            location = attr.toExternalForm();
        }
        return location;
    }
}

