/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class BlockingHttpConnection
extends HttpConnection {
    private volatile boolean _handling;

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        super(connector, endpoint, server, parser, generator, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        BlockingHttpConnection connection = this;
        boolean more_in_buffer = true;
        boolean progress = true;
        try {
            assert (BlockingHttpConnection.getCurrentConnection() == null);
            assert (!this._handling);
            this._handling = true;
            BlockingHttpConnection.setCurrentConnection(this);
            while (more_in_buffer && this._endp.isOpen()) {
                Connection switched;
                Object var7_8;
                block52: {
                    long written22;
                    int parsed;
                    if (!this._parser.isComplete() && (parsed = this._parser.parseAvailable()) > 0) {
                        progress = true;
                    }
                    while (this._generator.isCommitted() && !this._generator.isComplete() && (written22 = this._generator.flushBuffer()) > 0L) {
                        progress = true;
                        if (!this._endp.isBufferingOutput()) continue;
                        this._endp.flush();
                    }
                    if (this._endp.isBufferingOutput()) {
                        this._endp.flush();
                        if (!this._endp.isBufferingOutput()) {
                            progress = true;
                        }
                    }
                    if (progress) break block52;
                    BlockingHttpConnection written22 = this;
                    var7_8 = null;
                    boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        Connection connection2 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                        if (switched != null) {
                            this._parser.reset();
                            this._generator.reset(true);
                            connection = switched;
                        } else {
                            if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                this._parser.reset();
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (more_in_buffer) {
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            progress = true;
                        }
                    } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                        more_in_buffer = false;
                        this._endp.close();
                    }
                    if (this._request.isAsyncStarted()) {
                        throw new IllegalStateException();
                    }
                    if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp instanceof AsyncEndPoint) {
                        ((AsyncEndPoint)this._endp).scheduleWrite();
                    }
                    Object var10_10 = null;
                    this._parser.returnBuffers();
                    BlockingHttpConnection.setCurrentConnection(null);
                    this._handling = false;
                    return written22;
                }
                try {
                    try {
                        progress = false;
                    }
                    catch (HttpException e) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("uri=" + this._uri));
                            Log.debug((String)("fields=" + this._requestFields));
                            Log.debug((Throwable)e);
                        }
                        this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                        this._parser.reset();
                        this._endp.close();
                        var7_8 = null;
                        boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            Connection connection3 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                            if (switched != null) {
                                this._parser.reset();
                                this._generator.reset(true);
                                connection = switched;
                            } else {
                                if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                    this._parser.reset();
                                    more_in_buffer = false;
                                    this._endp.close();
                                }
                                if (more_in_buffer) {
                                    this.reset(false);
                                    more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                                } else {
                                    this.reset(true);
                                }
                                progress = true;
                            }
                        } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                            more_in_buffer = false;
                            this._endp.close();
                        }
                        if (this._request.isAsyncStarted()) {
                            throw new IllegalStateException();
                        }
                        if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) continue;
                        ((AsyncEndPoint)this._endp).scheduleWrite();
                        continue;
                    }
                    var7_8 = null;
                    boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        Connection connection4 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                        if (switched != null) {
                            this._parser.reset();
                            this._generator.reset(true);
                            connection = switched;
                        } else {
                            if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                this._parser.reset();
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (more_in_buffer) {
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            progress = true;
                        }
                    } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                        more_in_buffer = false;
                        this._endp.close();
                    }
                    if (this._request.isAsyncStarted()) {
                        throw new IllegalStateException();
                    }
                    if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof AsyncEndPoint)) continue;
                    ((AsyncEndPoint)this._endp).scheduleWrite();
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    boolean bl = more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                        Connection connection5 = switched = this._response.getStatus() == 101 ? (Connection)this._request.getAttribute("org.eclipse.jetty.io.Connection") : null;
                        if (switched != null) {
                            this._parser.reset();
                            this._generator.reset(true);
                            connection = switched;
                        } else {
                            if (!this._generator.isPersistent() || this._endp.isInputShutdown()) {
                                this._parser.reset();
                                more_in_buffer = false;
                                this._endp.close();
                            }
                            if (more_in_buffer) {
                                this.reset(false);
                                more_in_buffer = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            progress = true;
                        }
                    } else if (this._parser.isIdle() && this._endp.isInputShutdown()) {
                        more_in_buffer = false;
                        this._endp.close();
                    }
                    if (this._request.isAsyncStarted()) {
                        throw new IllegalStateException();
                    }
                    if (!this._generator.isCommitted()) throw throwable;
                    if (this._generator.isComplete()) throw throwable;
                    if (!(this._endp instanceof AsyncEndPoint)) throw throwable;
                    ((AsyncEndPoint)this._endp).scheduleWrite();
                    throw throwable;
                }
            }
            Object var10_11 = null;
            this._parser.returnBuffers();
            BlockingHttpConnection.setCurrentConnection(null);
            this._handling = false;
            return connection;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this._parser.returnBuffers();
            BlockingHttpConnection.setCurrentConnection(null);
            this._handling = false;
            throw throwable;
        }
    }
}

