/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.requestor;

import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.servicemix.jbi.cluster.requestor.AbstractPollingRequestorPool;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class GenericJmsRequestorPool
extends AbstractPollingRequestorPool {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private long receiveTimeout = 1000L;
    private boolean sharedConnectionEnabled = true;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private int idleTaskExecutionLimit = 1;
    private final Set<AsyncMessageListenerInvoker> scheduledInvokers = new HashSet<AsyncMessageListenerInvoker>();
    private int activeInvokerCount = 0;
    private Object currentRecoveryMarker = new Object();
    private final Object recoveryMonitor = new Object();
    private Runnable stopCallback;

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public boolean isSharedConnectionEnabled() {
        return this.sharedConnectionEnabled;
    }

    public void setSharedConnectionEnabled(boolean sharedConnectionEnabled) {
        this.sharedConnectionEnabled = sharedConnectionEnabled;
    }

    protected boolean sharedConnectionEnabled() {
        return this.isSharedConnectionEnabled();
    }

    protected AbstractPollingRequestorPool.Requestor createRequestor(boolean consume) throws JMSException {
        AbstractPollingRequestorPool.Requestor item = new AbstractPollingRequestorPool.Requestor();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getScheduledConsumerCount() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.scheduledInvokers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getActiveConsumerCount() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.activeInvokerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue((maxMessagesPerTask != 0 ? 1 : 0) != 0, (String)"'maxMessagesPerTask' must not be 0");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxMessagesPerTask() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.maxMessagesPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        Assert.isTrue((idleTaskExecutionLimit > 0 ? 1 : 0) != 0, (String)"'idleTaskExecutionLimit' must be 1 or higher");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleTaskExecutionLimit() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.idleTaskExecutionLimit;
        }
    }

    protected void messageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(false);
        this.scheduleNewInvokerIfAppropriate();
    }

    protected void noMessageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleNewInvokerIfAppropriate() {
        if (this.isRunning()) {
            this.resumePausedTasks();
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.scheduledInvokers.size() < this.maxConcurrentConsumers && this.getIdleInvokerCount() == 0) {
                    this.scheduleNewInvoker();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Raised scheduled invoker count: " + this.scheduledInvokers.size()));
                    }
                }
            }
        }
    }

    private void scheduleNewInvoker() {
        AsyncMessageListenerInvoker invoker = new AsyncMessageListenerInvoker();
        if (this.rescheduleTaskIfNecessary(invoker)) {
            this.scheduledInvokers.add(invoker);
        }
    }

    private boolean shouldRescheduleInvoker(int idleTaskExecutionCount) {
        boolean superfluous = idleTaskExecutionCount >= this.idleTaskExecutionLimit && this.getIdleInvokerCount() > 1;
        return this.scheduledInvokers.size() <= (superfluous ? this.concurrentConsumers : this.maxConcurrentConsumers);
    }

    private int getIdleInvokerCount() {
        int count = 0;
        for (AsyncMessageListenerInvoker invoker : this.scheduledInvokers) {
            if (!invoker.isIdle()) continue;
            ++count;
        }
        return count;
    }

    public AbstractPollingRequestorPool.Requestor getRequestor(String id) throws JMSException {
        AbstractPollingRequestorPool.Requestor item = null;
        if (id != null && (item = (AbstractPollingRequestorPool.Requestor)this.parked.remove(id)) != null) {
            item.resume();
        }
        if (item == null) {
            item = this.createRequestor(id == null);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInitialize() throws JMSException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            for (int i = 0; i < this.concurrentConsumers; ++i) {
                this.scheduleNewInvoker();
            }
        }
    }

    public void setMessageSelector(String selector) {
        super.setMessageSelector(selector);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using selector: " + selector));
        }
    }

    public class AsyncMessageListenerInvoker
    implements SchedulingAwareRunnable {
        private Object lastRecoveryMarker;
        private boolean lastMessageSucceeded;
        private int idleTaskExecutionCount = 0;
        private volatile boolean idle = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean messageReceived;
            block27: {
                Object object = GenericJmsRequestorPool.this.lifecycleMonitor;
                synchronized (object) {
                    GenericJmsRequestorPool.this.activeInvokerCount++;
                    GenericJmsRequestorPool.this.lifecycleMonitor.notifyAll();
                }
                this.updateRecoveryMarker();
                messageReceived = false;
                try {
                    if (GenericJmsRequestorPool.this.maxMessagesPerTask < 0) {
                        messageReceived = this.executeOngoingLoop();
                    } else {
                        for (int messageCount = 0; GenericJmsRequestorPool.this.isRunning() && messageCount < GenericJmsRequestorPool.this.maxMessagesPerTask; ++messageCount) {
                            messageReceived = this.invokeListener() || messageReceived;
                        }
                    }
                }
                catch (Exception ex) {
                    this.clearResources();
                    if (!this.lastMessageSucceeded) {
                        GenericJmsRequestorPool.this.sleepInbetweenRecoveryAttempts();
                    }
                    this.lastMessageSucceeded = false;
                    boolean alreadyRecovered = false;
                    Object object2 = GenericJmsRequestorPool.this.recoveryMonitor;
                    synchronized (object2) {
                        if (this.lastRecoveryMarker == GenericJmsRequestorPool.this.currentRecoveryMarker) {
                            GenericJmsRequestorPool.this.handleListenerSetupFailure(ex, false);
                            GenericJmsRequestorPool.this.recoverAfterListenerSetupFailure();
                            GenericJmsRequestorPool.this.currentRecoveryMarker = new Object();
                        } else {
                            alreadyRecovered = true;
                        }
                    }
                    if (!alreadyRecovered) break block27;
                    GenericJmsRequestorPool.this.handleListenerSetupFailure(ex, true);
                }
            }
            Object object = GenericJmsRequestorPool.this.lifecycleMonitor;
            synchronized (object) {
                this.decreaseActiveInvokerCount();
                GenericJmsRequestorPool.this.lifecycleMonitor.notifyAll();
            }
            this.idleTaskExecutionCount = !messageReceived ? ++this.idleTaskExecutionCount : 0;
            object = GenericJmsRequestorPool.this.lifecycleMonitor;
            synchronized (object) {
                if (!GenericJmsRequestorPool.this.shouldRescheduleInvoker(this.idleTaskExecutionCount) || !GenericJmsRequestorPool.this.rescheduleTaskIfNecessary(this)) {
                    GenericJmsRequestorPool.this.scheduledInvokers.remove(this);
                    if (GenericJmsRequestorPool.this.logger.isDebugEnabled()) {
                        GenericJmsRequestorPool.this.logger.debug((Object)("Lowered scheduled invoker count: " + GenericJmsRequestorPool.this.scheduledInvokers.size()));
                    }
                    GenericJmsRequestorPool.this.lifecycleMonitor.notifyAll();
                    this.clearResources();
                } else if (GenericJmsRequestorPool.this.isRunning()) {
                    int nonPausedConsumers = GenericJmsRequestorPool.this.getScheduledConsumerCount() - GenericJmsRequestorPool.this.getPausedTaskCount();
                    if (nonPausedConsumers < 1) {
                        GenericJmsRequestorPool.this.logger.error((Object)"All scheduled consumers have been paused, probably due to tasks having been rejected. Check your thread pool configuration! Manual recovery necessary through a start() call.");
                    } else if (nonPausedConsumers < GenericJmsRequestorPool.this.getConcurrentConsumers()) {
                        GenericJmsRequestorPool.this.logger.warn((Object)"Number of scheduled consumers has dropped below concurrentConsumers limit, probably due to tasks having been rejected. Check your thread pool configuration! Automatic recovery to be triggered by remaining consumers.");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean executeOngoingLoop() throws Exception {
            boolean messageReceived = false;
            boolean active = true;
            while (active) {
                Object object = GenericJmsRequestorPool.this.lifecycleMonitor;
                synchronized (object) {
                    boolean interrupted = false;
                    boolean wasWaiting = false;
                    while ((active = GenericJmsRequestorPool.this.isActive()) && !GenericJmsRequestorPool.this.isRunning()) {
                        if (interrupted) {
                            throw new IllegalStateException("Thread was interrupted while waiting for a restart of the listener container, but container is still stopped");
                        }
                        if (!wasWaiting) {
                            this.decreaseActiveInvokerCount();
                        }
                        wasWaiting = true;
                        try {
                            GenericJmsRequestorPool.this.lifecycleMonitor.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            interrupted = true;
                        }
                    }
                    if (wasWaiting) {
                        GenericJmsRequestorPool.this.activeInvokerCount++;
                    }
                }
                if (!active) continue;
                messageReceived = this.invokeListener() || messageReceived;
            }
            return messageReceived;
        }

        protected void decreaseActiveInvokerCount() {
            GenericJmsRequestorPool.this.activeInvokerCount--;
            if (GenericJmsRequestorPool.this.stopCallback != null && GenericJmsRequestorPool.this.activeInvokerCount == 0) {
                GenericJmsRequestorPool.this.stopCallback.run();
                GenericJmsRequestorPool.this.stopCallback = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean invokeListener() throws Exception {
            AbstractPollingRequestorPool.Requestor req;
            boolean messageReceived = false;
            AbstractPollingRequestorPool.Requestor requestor = req = GenericJmsRequestorPool.this.createRequestor(true);
            synchronized (requestor) {
                try {
                    req.begin();
                    boolean bl = messageReceived = req.receive(GenericJmsRequestorPool.this.receiveTimeout) != null;
                    if (messageReceived) {
                        if (GenericJmsRequestorPool.this.logger.isDebugEnabled()) {
                            GenericJmsRequestorPool.this.logger.debug((Object)("Received message of type [" + req.getMessage().getClass() + "] from consumer"));
                        }
                        GenericJmsRequestorPool.this.messageReceived(this, req.getSession());
                        GenericJmsRequestorPool.this.listener.onMessage(req);
                        this.lastMessageSucceeded = true;
                    } else {
                        if (GenericJmsRequestorPool.this.logger.isTraceEnabled()) {
                            GenericJmsRequestorPool.this.logger.trace((Object)"Consumer did not receive a message");
                        }
                        GenericJmsRequestorPool.this.noMessageReceived(this, req.getSession());
                        this.lastMessageSucceeded = true;
                    }
                }
                finally {
                    if (req != null) {
                        req.close();
                    }
                }
            }
            return messageReceived;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRecoveryMarker() {
            Object object = GenericJmsRequestorPool.this.recoveryMonitor;
            synchronized (object) {
                this.lastRecoveryMarker = GenericJmsRequestorPool.this.currentRecoveryMarker;
            }
        }

        private void clearResources() {
        }

        public boolean isLongLived() {
            return GenericJmsRequestorPool.this.maxMessagesPerTask < 0;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
        }

        public boolean isIdle() {
            return this.idle;
        }
    }
}

