/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.spi.RouteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    private Logger log = LoggerFactory.getLogger(Logger.class);
    private LoggingLevel level = LoggingLevel.ERROR;

    public LoggingErrorHandlerBuilder() {
    }

    public LoggingErrorHandlerBuilder(Logger log) {
        this.log = log;
    }

    public LoggingErrorHandlerBuilder(Logger log, LoggingLevel level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        CamelLogger logger = new CamelLogger(this.log, this.level);
        LoggingErrorHandler handler = new LoggingErrorHandler(routeContext.getCamelContext(), processor, logger, this.getExceptionPolicyStrategy());
        this.configure(routeContext, handler);
        return handler;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public String getLogName() {
        return this.log != null ? this.log.getName() : null;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger((String)logName);
    }

    public LoggingErrorHandlerBuilder level(LoggingLevel level) {
        this.level = level;
        return this;
    }

    public LoggingErrorHandlerBuilder log(Logger log) {
        this.log = log;
        return this;
    }

    public LoggingErrorHandlerBuilder logName(String logName) {
        this.setLogName(logName);
        return this;
    }
}

