/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultPropertiesResolver
implements PropertiesResolver {
    @Override
    public Properties resolveProperties(CamelContext context, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String path : uri) {
            Properties prop;
            if (path.startsWith("ref:")) {
                prop = this.loadPropertiesFromRegistry(context, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            if (path.startsWith("file:")) {
                prop = this.loadPropertiesFromFilePath(context, path);
                prop = this.prepareLoadedProperties(prop);
                answer.putAll((Map<?, ?>)prop);
                continue;
            }
            prop = this.loadPropertiesFromClasspath(context, path);
            prop = this.prepareLoadedProperties(prop);
            answer.putAll((Map<?, ?>)prop);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromFilePath(CamelContext context, String path) throws IOException {
        Properties answer = null;
        if (path.startsWith("file:")) {
            path = ObjectHelper.after(path, "file:");
        }
        FileInputStream is = new FileInputStream(path);
        try {
            answer = new Properties();
            answer.load(is);
        }
        finally {
            IOHelper.close(is);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertiesFromClasspath(CamelContext context, String path) throws IOException {
        InputStream is;
        Properties answer = null;
        if (path.startsWith("classpath:")) {
            path = ObjectHelper.after(path, "classpath:");
        }
        if ((is = context.getClassResolver().loadResourceAsStream(path)) == null) {
            throw new FileNotFoundException("Properties file " + path + " not found in classpath");
        }
        try {
            answer = new Properties();
            answer.load(is);
        }
        finally {
            IOHelper.close(is);
        }
        return answer;
    }

    protected Properties loadPropertiesFromRegistry(CamelContext context, String path) throws IOException {
        Properties answer;
        if (path.startsWith("ref:")) {
            path = ObjectHelper.after(path, "ref:");
        }
        if ((answer = context.getRegistry().lookup(path, Properties.class)) == null) {
            throw new FileNotFoundException("Properties " + path + " not found in registry");
        }
        return answer;
    }

    protected Properties prepareLoadedProperties(Properties properties) {
        Properties answer = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                s = s.trim();
                value = s;
            }
            answer.put(key, value);
        }
        return answer;
    }
}

