/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.util.ObjectHelper;

public class BytesSource
extends StreamSource
implements Serializable {
    private static final long serialVersionUID = 124123201106542082L;
    private final byte[] data;

    public BytesSource(byte[] data) {
        ObjectHelper.notNull(data, "data");
        this.data = data;
    }

    public BytesSource(byte[] data, String systemId) {
        ObjectHelper.notNull(data, "data");
        this.data = data;
        this.setSystemId(systemId);
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "BytesSource[" + new String(this.data) + "]";
    }
}

