/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Converter
public final class DomConverter {
    private final XmlConverter xml = new XmlConverter();

    @Converter
    public String toString(NodeList nodeList, Exchange exchange) throws TransformerException {
        StringBuilder buffer = new StringBuilder();
        boolean found = false;
        if (nodeList instanceof Node) {
            Node node = (Node)((Object)nodeList);
            String s = this.xml.toString(node, exchange);
            if (ObjectHelper.isNotEmpty(s)) {
                found = true;
                buffer.append(s);
            }
        } else {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                String s = this.xml.toString(node, exchange);
                if (!ObjectHelper.isNotEmpty(s)) continue;
                found = true;
                buffer.append(s);
            }
        }
        if (!found) {
            DomConverter.append(buffer, nodeList);
        }
        return buffer.toString();
    }

    @Converter
    public Integer toInteger(NodeList nodeList) {
        StringBuilder buffer = new StringBuilder();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Integer.valueOf(s);
    }

    @Converter
    public Long toLong(NodeList nodeList) {
        StringBuilder buffer = new StringBuilder();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Long.valueOf(s);
    }

    @Converter
    public static List toList(NodeList nodeList) {
        ArrayList<Object> answer = new ArrayList<Object>();
        Iterator<Object> it = ObjectHelper.createIterator(nodeList);
        while (it.hasNext()) {
            answer.add(it.next());
        }
        return answer;
    }

    @Converter
    public InputStream toInputStream(NodeList nodeList, Exchange exchange) throws TransformerException {
        return new ByteArrayInputStream(this.toByteArray(nodeList, exchange));
    }

    @Converter
    public byte[] toByteArray(NodeList nodeList, Exchange exchange) throws TransformerException {
        String data = this.toString(nodeList, exchange);
        return data.getBytes();
    }

    private static void append(StringBuilder buffer, NodeList nodeList) {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            DomConverter.append(buffer, nodeList.item(i));
        }
    }

    private static void append(StringBuilder buffer, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            buffer.append(text.getTextContent());
        } else if (node instanceof Attr) {
            Attr attribute = (Attr)node;
            buffer.append(attribute.getTextContent());
        } else if (node instanceof Element) {
            Element element = (Element)node;
            DomConverter.append(buffer, element.getChildNodes());
        }
    }
}

