/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fabric;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.fabric.FabricTraceProcessor;
import org.apache.camel.fabric.FabricTracerEventMessage;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(value="FabricTracer")
public class FabricTracer
extends ServiceSupport
implements InterceptStrategy {
    private final CamelContext camelContext;
    private boolean enabled;
    private final AtomicLong traceCounter = new AtomicLong(0L);
    private Queue<FabricTracerEventMessage> queue = new ArrayBlockingQueue<FabricTracerEventMessage>(1000);
    private int queueSize = 10;
    private final Set<ProcessorDefinition<?>> processors = new HashSet();

    public FabricTracer(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        this.processors.add(definition);
        return new FabricTraceProcessor(this.queue, target, definition, this);
    }

    public boolean shouldTrace(ProcessorDefinition<?> definition) {
        return this.enabled;
    }

    @ManagedAttribute(description="Is tracing enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @ManagedAttribute(description="Is tracing enabled")
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.forceAutoAssigningIds();
        }
        this.enabled = enabled;
    }

    @ManagedAttribute(description="Number of traced messages to keep in FIFO queue")
    public int getQueueSize() {
        return this.queueSize;
    }

    @ManagedAttribute(description="Number of traced messages to keep in FIFO queue")
    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("The queue size must be a positive number, was: " + queueSize);
        }
        this.queueSize = queueSize;
    }

    @ManagedAttribute(description="Number of total traced messages")
    public long getTraceCounter() {
        return this.traceCounter.get();
    }

    @ManagedOperation(description="Resets the trace counter")
    public void resetTraceCounter() {
        this.traceCounter.set(0L);
    }

    @ManagedOperation(description="Dumps the traced messages for the given node")
    public List<FabricTracerEventMessage> dumpTracedMessages(String nodeId) {
        ArrayList<FabricTracerEventMessage> answer = new ArrayList<FabricTracerEventMessage>();
        if (nodeId != null) {
            for (FabricTracerEventMessage message : this.queue) {
                if (!nodeId.equals(message.getToNode())) continue;
                answer.add(message);
            }
        }
        return answer;
    }

    @ManagedOperation(description="Dumps the traced messages for the given node in xml format")
    public String dumpTracedMessagesAsXml(String nodeId) {
        List<FabricTracerEventMessage> events = this.dumpTracedMessages(nodeId);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("fabricTracerEventMessage").append("s>");
        for (FabricTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml());
        }
        sb.append("\n</").append("fabricTracerEventMessage").append("s>");
        return sb.toString();
    }

    @ManagedOperation(description="Dumps the traced messages for all nodes")
    public List<FabricTracerEventMessage> dumpAllTracedMessages() {
        ArrayList<FabricTracerEventMessage> answer = new ArrayList<FabricTracerEventMessage>();
        answer.addAll(this.queue);
        this.queue.clear();
        return answer;
    }

    @ManagedOperation(description="Dumps the traced messages for all nodes in xml format")
    public String dumpAllTracedMessagesAsXml() {
        List<FabricTracerEventMessage> events = this.dumpAllTracedMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("fabricTracerEventMessage").append("s>");
        for (FabricTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml());
        }
        sb.append("\n</").append("fabricTracerEventMessage").append("s>");
        return sb.toString();
    }

    long incrementTraceCounter() {
        return this.traceCounter.incrementAndGet();
    }

    void stopProcessor(FabricTraceProcessor processor, ProcessorDefinition<?> processorDefinition) {
        this.processors.remove(processorDefinition);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        this.queue.clear();
    }

    @Override
    protected void doShutdown() throws Exception {
        this.queue.clear();
        this.processors.clear();
    }

    private void forceAutoAssigningIds() {
        NodeIdFactory factory = this.camelContext.getNodeIdFactory();
        if (factory != null) {
            for (ProcessorDefinition<?> child : this.processors) {
                RouteDefinitionHelper.forceAssignIds(this.camelContext, child);
            }
        }
    }
}

