/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fabric;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.MessageHelper;

public class FabricTracerEventMessage
implements Serializable {
    public static final String ROOT_TAG = "fabricTracerEventMessage";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final long serialVersionUID = 1L;
    private final long uid;
    private final Date timestamp;
    private final String toNode;
    private final String exchangeId;
    private final String messageAsXml;

    public FabricTracerEventMessage(long uid, Exchange exchange, ProcessorDefinition<?> toNode) {
        this.uid = uid;
        this.timestamp = new Date();
        this.toNode = toNode.getId();
        this.exchangeId = exchange.getExchangeId();
        this.messageAsXml = MessageHelper.dumpAsXml(exchange.getIn());
    }

    public long getUid() {
        return this.uid;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    public String toString() {
        return "FabricTraceEvent[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(ROOT_TAG).append(">\n");
        sb.append("<uid>").append(this.uid).append("</uid>\n");
        String ts = new SimpleDateFormat(TIMESTAMP_FORMAT).format(this.timestamp);
        sb.append("<timestamp>").append(ts).append("</timestamp>\n");
        sb.append("<toNode>").append(this.toNode).append("</toNode>\n");
        sb.append("<exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        sb.append(this.messageAsXml).append("\n");
        sb.append("</").append(ROOT_TAG).append(">");
        return sb.toString();
    }
}

