/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.ThreadPoolProfileSupport;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutorServiceStrategy
extends ServiceSupport
implements ExecutorServiceStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutorServiceStrategy.class);
    private final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private final CamelContext camelContext;
    private String threadNamePattern;
    private String defaultThreadPoolProfileId;
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new HashMap<String, ThreadPoolProfile>();

    public DefaultExecutorServiceStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.defaultThreadPoolProfileId = "defaultThreadPoolProfile";
        ThreadPoolProfileSupport defaultProfile = new ThreadPoolProfileSupport(this.defaultThreadPoolProfileId);
        defaultProfile.setDefaultProfile(true);
        defaultProfile.setPoolSize(10);
        defaultProfile.setMaxPoolSize(20);
        defaultProfile.setKeepAliveTime(60L);
        defaultProfile.setTimeUnit(TimeUnit.SECONDS);
        defaultProfile.setMaxQueueSize(1000);
        defaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(defaultProfile);
    }

    @Override
    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    @Override
    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    @Override
    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        ThreadPoolProfile oldProfile = this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        if (oldProfile != null) {
            oldProfile.setDefaultProfile(false);
            if (defaultThreadPoolProfile.getKeepAliveTime() == null) {
                defaultThreadPoolProfile.setKeepAliveTime(oldProfile.getKeepAliveTime());
            }
            if (defaultThreadPoolProfile.getMaxPoolSize() == null) {
                defaultThreadPoolProfile.setMaxPoolSize(oldProfile.getMaxPoolSize());
            }
            if (defaultThreadPoolProfile.getRejectedPolicy() == null) {
                defaultThreadPoolProfile.setRejectedPolicy(oldProfile.getRejectedPolicy());
            }
            if (defaultThreadPoolProfile.getMaxQueueSize() == null) {
                defaultThreadPoolProfile.setMaxQueueSize(oldProfile.getMaxQueueSize());
            }
            if (defaultThreadPoolProfile.getPoolSize() == null) {
                defaultThreadPoolProfile.setPoolSize(oldProfile.getPoolSize());
            }
            if (defaultThreadPoolProfile.getTimeUnit() == null) {
                defaultThreadPoolProfile.setTimeUnit(oldProfile.getTimeUnit());
            }
        }
        ObjectHelper.notEmpty(defaultThreadPoolProfile.getId(), "id", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getKeepAliveTime(), "keepAliveTime", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getMaxPoolSize(), "maxPoolSize", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getMaxQueueSize(), "maxQueueSize", defaultThreadPoolProfile);
        ObjectHelper.notNull(defaultThreadPoolProfile.getPoolSize(), "poolSize", defaultThreadPoolProfile);
        ObjectHelper.notNull((Object)defaultThreadPoolProfile.getTimeUnit(), "timeUnit", defaultThreadPoolProfile);
        LOG.info("Using custom DefaultThreadPoolProfile: " + defaultThreadPoolProfile);
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(true);
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    @Override
    public String getThreadName(String name) {
        return ExecutorServiceHelper.getThreadName(this.threadNamePattern, name);
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    @Override
    public void setThreadNamePattern(String threadNamePattern) {
        String name;
        this.threadNamePattern = name = threadNamePattern.replaceFirst("\\$\\{camelId\\}", this.camelContext.getName());
    }

    @Override
    public ExecutorService lookup(Object source, String name, String executorServiceRef) {
        ExecutorService answer = this.camelContext.getRegistry().lookup(executorServiceRef, ExecutorService.class);
        if (answer != null) {
            LOG.debug("Looking up ExecutorService with ref: {} and found it from Registry: {}", (Object)executorServiceRef, (Object)answer);
        }
        if (answer == null && (answer = this.newThreadPool(source, name, executorServiceRef)) != null) {
            LOG.debug("Looking up ExecutorService with ref: {} and found a matching ThreadPoolProfile to create the ExecutorService: {}", (Object)executorServiceRef, (Object)answer);
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService lookupScheduled(Object source, String name, String executorServiceRef) {
        ThreadPoolProfile profile;
        ScheduledExecutorService answer = this.camelContext.getRegistry().lookup(executorServiceRef, ScheduledExecutorService.class);
        if (answer != null) {
            LOG.debug("Looking up ScheduledExecutorService with ref: {} and found it from Registry: {}", (Object)executorServiceRef, (Object)answer);
        }
        if (answer == null && (profile = this.getThreadPoolProfile(executorServiceRef)) != null) {
            Integer maxQueueSize;
            Integer poolSize = profile.getPoolSize();
            if (poolSize == null) {
                poolSize = this.getDefaultThreadPoolProfile().getPoolSize();
            }
            if ((maxQueueSize = profile.getMaxQueueSize()) == null) {
                maxQueueSize = this.getDefaultThreadPoolProfile().getMaxQueueSize();
            }
            if ((answer = this.newScheduledThreadPool(source, name, poolSize, maxQueueSize)) != null) {
                LOG.debug("Looking up ScheduledExecutorService with ref: {} and found a matching ThreadPoolProfile to create the ScheduledExecutorService: {}", (Object)executorServiceRef, (Object)answer);
            }
        }
        return answer;
    }

    @Override
    public ExecutorService newDefaultThreadPool(Object source, String name) {
        ThreadPoolProfile profile = this.getDefaultThreadPoolProfile();
        ObjectHelper.notNull(profile, "DefaultThreadPoolProfile");
        return this.newThreadPool(source, name, profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getTimeUnit(), profile.getMaxQueueSize(), profile.getRejectedExecutionHandler(), false);
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, String threadPoolProfileId) {
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        ThreadPoolProfile profile = this.getThreadPoolProfile(threadPoolProfileId);
        if (profile != null) {
            Integer poolSize = profile.getPoolSize() != null ? profile.getPoolSize() : defaultProfile.getPoolSize();
            Integer maxPoolSize = profile.getMaxPoolSize() != null ? profile.getMaxPoolSize() : defaultProfile.getMaxPoolSize();
            Long keepAliveTime = profile.getKeepAliveTime() != null ? profile.getKeepAliveTime() : defaultProfile.getKeepAliveTime();
            TimeUnit timeUnit = profile.getTimeUnit() != null ? profile.getTimeUnit() : defaultProfile.getTimeUnit();
            Integer maxQueueSize = profile.getMaxQueueSize() != null ? profile.getMaxQueueSize() : defaultProfile.getMaxQueueSize();
            RejectedExecutionHandler handler = profile.getRejectedExecutionHandler() != null ? profile.getRejectedExecutionHandler() : defaultProfile.getRejectedExecutionHandler();
            return this.newThreadPool(threadPoolProfileId, source, name, poolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, handler, false);
        }
        return null;
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source, String name) {
        ExecutorService answer = ExecutorServiceHelper.newCachedThreadPool(this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new cached thread pool for source: {} with name: {}. -> {}", new Object[]{source, name, answer});
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name) {
        int poolSize = this.getDefaultThreadPoolProfile().getPoolSize();
        int queueSize = this.getDefaultThreadPoolProfile().getMaxQueueSize();
        return this.newScheduledThreadPool(source, name, poolSize, queueSize);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize) {
        return this.newScheduledThreadPool(source, name, poolSize, 0);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize, int maxQueueSize) {
        ScheduledExecutorService answer = ExecutorServiceHelper.newScheduledThreadPool(poolSize, maxQueueSize, this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new scheduled thread pool for source: {} with name: {}. [poolSize={}, maxQueueSize={}]. -> {}", new Object[]{source, name, poolSize, maxQueueSize, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        ExecutorService answer = ExecutorServiceHelper.newFixedThreadPool(poolSize, this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new fixed thread pool for source: {} with name: {}. [poolSize={}]. -> {}", new Object[]{source, name, poolSize, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newSingleThreadExecutor(Object source, String name) {
        ExecutorService answer = ExecutorServiceHelper.newSingleThreadExecutor(this.threadNamePattern, name, true);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new single thread pool for source: {} with name: {}. -> {}", new Object[]{source, name, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newSynchronousThreadPool(Object source, String name) {
        ExecutorService answer = ExecutorServiceHelper.newSynchronousThreadPool();
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new synchronous thread pool for source: {} with name: {}. -> {}", new Object[]{source, name, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int corePoolSize, int maxPoolSize) {
        ExecutorService answer = ExecutorServiceHelper.newThreadPool(this.threadNamePattern, name, corePoolSize, maxPoolSize);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new thread pool for source: {} with name: {}. [poolSize={}, maxPoolSize={}] -> {}", new Object[]{source, name, corePoolSize, maxPoolSize, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int corePoolSize, int maxPoolSize, int maxQueueSize) {
        ExecutorService answer = ExecutorServiceHelper.newThreadPool(this.threadNamePattern, name, corePoolSize, maxPoolSize, maxQueueSize);
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new thread pool for source: {} with name: {}. [poolSize={}, maxPoolSize={}, maxQueueSize={}] -> {}", new Object[]{source, name, corePoolSize, maxPoolSize, maxQueueSize, answer});
        }
        return answer;
    }

    private ExecutorService newThreadPool(String threadPoolProfileId, Object source, String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, boolean daemon) {
        ObjectHelper.notNull(name, "ThreadName");
        if (corePoolSize < 1) {
            throw new IllegalArgumentException("The corePoolSize can't be lower than 1");
        }
        ExecutorService answer = ExecutorServiceHelper.newThreadPool(this.threadNamePattern, name, corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, rejectedExecutionHandler, daemon);
        this.onThreadPoolCreated(answer, source, threadPoolProfileId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new thread pool for source: {} with name: {}. [poolSize={}, maxPoolSize={}, keepAliveTime={} {}, maxQueueSize={}, rejectedExecutionHandler={}, daemon={}] -> {}", new Object[]{source, name, corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, rejectedExecutionHandler, daemon, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, boolean daemon) {
        return this.newThreadPool(null, source, name, corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, rejectedExecutionHandler, daemon);
    }

    @Override
    public void shutdown(ExecutorService executorService) {
        ObjectHelper.notNull(executorService, "executorService");
        this.executorServices.remove(executorService);
        if (executorService.isShutdown()) {
            return;
        }
        LOG.debug("Shutdown ExecutorService: {}", (Object)executorService);
        executorService.shutdown();
        LOG.trace("Shutdown ExecutorService: {} complete.", (Object)executorService);
    }

    @Override
    public List<Runnable> shutdownNow(ExecutorService executorService) {
        return this.doShutdownNow(executorService, true);
    }

    private List<Runnable> doShutdownNow(ExecutorService executorService, boolean remove) {
        ObjectHelper.notNull(executorService, "executorService");
        if (remove) {
            this.executorServices.remove(executorService);
        }
        if (executorService.isShutdown()) {
            return null;
        }
        LOG.debug("ShutdownNow ExecutorService: {}", (Object)executorService);
        List<Runnable> answer = executorService.shutdownNow();
        LOG.trace("ShutdownNow ExecutorService: {} complete.", (Object)executorService);
        return answer;
    }

    protected void onThreadPoolCreated(ExecutorService executorService, Object source, String threadPoolProfileId) {
        RouteDefinition route;
        String id;
        this.executorServices.add(executorService);
        String sourceId = null;
        String routeId = null;
        if (source instanceof OptionalIdentifiedDefinition) {
            id = ((OptionalIdentifiedDefinition)source).idOrCreate(this.camelContext.getNodeIdFactory());
            sourceId = ((OptionalIdentifiedDefinition)source).getShortName();
        } else {
            id = source instanceof String ? (String)source : (source != null ? source.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(source) + ")" : executorService.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(executorService) + ")");
        }
        ObjectHelper.notEmpty(id, "id for thread pool " + executorService);
        if (source instanceof ProcessorDefinition && (route = ProcessorDefinitionHelper.getRoute((ProcessorDefinition)source)) != null) {
            routeId = route.idOrCreate(this.camelContext.getNodeIdFactory());
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            threadPool = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            threadPool = ((SizedScheduledExecutorService)executorService).getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
            }
        }
        this.onNewExecutorService(executorService);
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.threadNamePattern == null) {
            this.threadNamePattern = "Camel (" + this.camelContext.getName() + ") thread #${counter} - ${name}";
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        for (ExecutorService executorService : this.executorServices) {
            try {
                this.doShutdownNow(executorService, false);
            }
            catch (Throwable e) {
                LOG.warn("Error occurred during shutdown of ExecutorService: " + executorService + ". This exception will be ignored.", e);
            }
        }
        this.executorServices.clear();
        Iterator<ThreadPoolProfile> it = this.threadPoolProfiles.values().iterator();
        while (it.hasNext()) {
            ThreadPoolProfile profile = it.next();
            if (profile.isDefaultProfile().booleanValue()) continue;
            it.remove();
        }
    }
}

