/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.InflightRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final AtomicInteger totalCount = new AtomicInteger();
    private final Map<String, AtomicInteger> endpointCount = new HashMap<String, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Exchange exchange) {
        int count = this.totalCount.incrementAndGet();
        LOG.trace("Total {} inflight exchanges. Last added: {}", (Object)count, (Object)exchange.getExchangeId());
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        Map<String, AtomicInteger> map = this.endpointCount;
        synchronized (map) {
            AtomicInteger existing = this.endpointCount.get(key);
            if (existing != null) {
                existing.incrementAndGet();
            } else {
                this.endpointCount.put(key, new AtomicInteger(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Exchange exchange) {
        int count = this.totalCount.decrementAndGet();
        LOG.trace("Total {} inflight exchanges. Last removed: {}", (Object)count, (Object)exchange.getExchangeId());
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        Map<String, AtomicInteger> map = this.endpointCount;
        synchronized (map) {
            AtomicInteger existing = this.endpointCount.get(key);
            if (existing != null && existing.decrementAndGet() <= 0) {
                this.endpointCount.remove(key);
            }
        }
    }

    int endpointSize() {
        return this.endpointCount.size();
    }

    @Override
    public int size() {
        return this.totalCount.get();
    }

    @Override
    public int size(Endpoint endpoint) {
        AtomicInteger answer = this.endpointCount.get(endpoint.getEndpointKey());
        return answer != null ? answer.get() : 0;
    }

    @Override
    protected void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still " + count + " in flight exchanges.");
        } else {
            LOG.info("Shutting down with no inflight exchanges.");
        }
        Map<String, AtomicInteger> map = this.endpointCount;
        synchronized (map) {
            this.endpointCount.clear();
        }
    }
}

