/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.fusesource.commons.management.Statistic;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic failuresHandled;
    private Statistic redeliveries;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private Statistic firstExchangeFailureTimestamp;
    private Statistic lastExchangeCompletedTimestamp;
    private Statistic lastExchangeFailureTimestamp;
    private boolean statisticsEnabled = true;

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = strategy.createStatistic("org.apache.camel.exchangesCompleted", this, Statistic.UpdateMode.COUNTER);
        this.exchangesFailed = strategy.createStatistic("org.apache.camel.exchangesFailed", this, Statistic.UpdateMode.COUNTER);
        this.failuresHandled = strategy.createStatistic("org.apache.camel.failuresHandled", this, Statistic.UpdateMode.COUNTER);
        this.redeliveries = strategy.createStatistic("org.apache.camel.redeliveries", this, Statistic.UpdateMode.COUNTER);
        this.minProcessingTime = strategy.createStatistic("org.apache.camel.minimumProcessingTime", this, Statistic.UpdateMode.MINIMUM);
        this.maxProcessingTime = strategy.createStatistic("org.apache.camel.maximumProcessingTime", this, Statistic.UpdateMode.MAXIMUM);
        this.totalProcessingTime = strategy.createStatistic("org.apache.camel.totalProcessingTime", this, Statistic.UpdateMode.COUNTER);
        this.lastProcessingTime = strategy.createStatistic("org.apache.camel.lastProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.meanProcessingTime = strategy.createStatistic("org.apache.camel.meanProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeCompletedTimestamp = strategy.createStatistic("org.apache.camel.firstExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeFailureTimestamp = strategy.createStatistic("org.apache.camel.firstExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeCompletedTimestamp = strategy.createStatistic("org.apache.camel.lastExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeFailureTimestamp = strategy.createStatistic("org.apache.camel.lastExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
    }

    @Override
    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.failuresHandled.reset();
        this.redeliveries.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeFailureTimestamp.reset();
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeFailureTimestamp.reset();
    }

    @ManagedAttribute(description="Number of completed exchanges")
    public long getExchangesCompleted() {
        return this.exchangesCompleted.getValue();
    }

    @ManagedAttribute(description="Number of failed exchanges")
    public long getExchangesFailed() {
        return this.exchangesFailed.getValue();
    }

    @ManagedAttribute(description="Number of failures handled")
    public long getFailuresHandled() {
        return this.failuresHandled.getValue();
    }

    @ManagedAttribute(description="Number of redeliveries")
    public long getRedeliveries() {
        return this.redeliveries.getValue();
    }

    @ManagedAttribute(description="Min Processing Time [milliseconds]")
    public long getMinProcessingTime() {
        return this.minProcessingTime.getValue();
    }

    @ManagedAttribute(description="Mean Processing Time [milliseconds]")
    public long getMeanProcessingTime() {
        return this.meanProcessingTime.getValue();
    }

    @ManagedAttribute(description="Max Processing Time [milliseconds]")
    public long getMaxProcessingTime() {
        return this.maxProcessingTime.getValue();
    }

    @ManagedAttribute(description="Total Processing Time [milliseconds]")
    public long getTotalProcessingTime() {
        return this.totalProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Processing Time [milliseconds]")
    public long getLastProcessingTime() {
        return this.lastProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Exchange Completed Timestamp")
    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Completed Timestamp")
    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="Last Exchange Failed Timestamp")
    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Failed Timestamp")
    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    @ManagedAttribute(description="Statistics enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    @ManagedAttribute(description="Statistics enabled")
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public synchronized void completedExchange(Exchange exchange, long time) {
        this.increment();
        this.exchangesCompleted.increment();
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.failuresHandled.increment();
        }
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        long now = new Date().getTime();
        if (this.firstExchangeCompletedTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        long count = this.exchangesCompleted.getValue();
        long mean = count > 0L ? this.totalProcessingTime.getValue() / count : 0L;
        this.meanProcessingTime.updateValue(mean);
    }

    @Override
    public synchronized void failedExchange(Exchange exchange) {
        this.increment();
        this.exchangesFailed.increment();
        if (ExchangeHelper.isRedelivered(exchange)) {
            this.redeliveries.increment();
        }
        long now = new Date().getTime();
        if (this.firstExchangeFailureTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
    }

    @ManagedOperation(description="Dumps the statistics as XML")
    public String dumpStatsAsXml(boolean fullStats) {
        StringBuilder sb = new StringBuilder();
        sb.append("<stats ");
        sb.append(String.format("exchangesCompleted=\"%s\"", this.exchangesCompleted.getValue()));
        sb.append(String.format(" exchangesFailed=\"%s\"", this.exchangesFailed.getValue()));
        sb.append(String.format(" failuresHandled=\"%s\"", this.failuresHandled.getValue()));
        sb.append(String.format(" redeliveries=\"%s\"", this.redeliveries.getValue()));
        sb.append(String.format(" minProcessingTime=\"%s\"", this.minProcessingTime.getValue()));
        sb.append(String.format(" maxProcessingTime=\"%s\"", this.maxProcessingTime.getValue()));
        sb.append(String.format(" totalProcessingTime=\"%s\"", this.totalProcessingTime.getValue()));
        sb.append(String.format(" lastProcessingTime=\"%s\"", this.lastProcessingTime.getValue()));
        sb.append(String.format(" meanProcessingTime=\"%s\"", this.meanProcessingTime.getValue()));
        if (fullStats) {
            sb.append(String.format(" firstExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" firstExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeFailureTimestamp.getValue())));
            sb.append(String.format(" lastExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" lastExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeFailureTimestamp.getValue())));
        }
        sb.append("/>");
        return sb.toString();
    }

    private static String dateAsString(long value) {
        if (value == 0L) {
            return "";
        }
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(value);
    }

    private static String nullSafe(String s) {
        return s != null ? s : "";
    }
}

