/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.processor.loadbalancer.StickyLoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;

@XmlRootElement(name="loadBalance")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalanceDefinition
extends ProcessorDefinition<LoadBalanceDefinition> {
    @XmlAttribute
    @Deprecated
    private String ref;
    @XmlElements(value={@XmlElement(required=false, name="failover", type=FailoverLoadBalancerDefinition.class), @XmlElement(required=false, name="random", type=RandomLoadBalancerDefinition.class), @XmlElement(required=false, name="custom", type=CustomLoadBalancerDefinition.class), @XmlElement(required=false, name="roundRobin", type=RoundRobinLoadBalancerDefinition.class), @XmlElement(required=false, name="sticky", type=StickyLoadBalancerDefinition.class), @XmlElement(required=false, name="topic", type=TopicLoadBalancerDefinition.class), @XmlElement(required=false, name="weighted", type=WeightedLoadBalancerDefinition.class)})
    private LoadBalancerDefinition loadBalancerType;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();

    @Override
    public String getShortName() {
        return "loadbalance";
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public LoadBalancerDefinition getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerDefinition loadbalancer) {
        if (this.loadBalancerType != null) {
            throw new IllegalArgumentException("Loadbalancer already configured to: " + this.loadBalancerType + ". Cannot set it to: " + loadbalancer);
        }
        this.loadBalancerType = loadbalancer;
    }

    @Override
    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorDefinition> outputs) throws Exception {
        LoadBalancer loadBalancer = LoadBalancerDefinition.getLoadBalancer(routeContext, this.loadBalancerType, this.ref);
        for (ProcessorDefinition processorType : outputs) {
            Processor processor = processorType.createProcessor(routeContext);
            loadBalancer.addProcessor(processor);
        }
        return loadBalancer;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        LoadBalancer loadBalancer = LoadBalancerDefinition.getLoadBalancer(routeContext, this.loadBalancerType, this.ref);
        for (ProcessorDefinition processorType : this.getOutputs()) {
            if (processorType instanceof LoadBalanceDefinition) {
                throw new IllegalArgumentException("Loadbalancer already configured to: " + this.loadBalancerType + ". Cannot set it to: " + processorType);
            }
            Processor processor = processorType.createProcessor(routeContext);
            processor = this.wrapChannel(routeContext, processor, processorType);
            loadBalancer.addProcessor(processor);
        }
        return loadBalancer;
    }

    @Override
    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        this.setLoadBalancerType(new LoadBalancerDefinition(loadBalancer));
        return this;
    }

    public LoadBalanceDefinition failover() {
        return this.failover(-1, true, false, new Class[0]);
    }

    public LoadBalanceDefinition failover(Class<?> ... exceptions) {
        return this.failover(-1, true, false, exceptions);
    }

    public LoadBalanceDefinition failover(int maximumFailoverAttempts, boolean inheritErrorHandler, boolean roundRobin, Class<?> ... exceptions) {
        FailOverLoadBalancer failover = new FailOverLoadBalancer(Arrays.asList(exceptions));
        failover.setMaximumFailoverAttempts(maximumFailoverAttempts);
        failover.setRoundRobin(roundRobin);
        this.setLoadBalancerType(new LoadBalancerDefinition(failover));
        this.setInheritErrorHandler(inheritErrorHandler);
        return this;
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio) {
        return this.weighted(roundRobin, distributionRatio, ",");
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio, String distributionRatioDelimiter) {
        String[] ratios;
        ArrayList<Integer> distributionRatioList = new ArrayList<Integer>();
        for (String ratio : ratios = distributionRatio.split(distributionRatioDelimiter)) {
            distributionRatioList.add(new Integer(ratio.trim()));
        }
        WeightedLoadBalancer weighted = !roundRobin ? new WeightedRandomLoadBalancer(distributionRatioList) : new WeightedRoundRobinLoadBalancer(distributionRatioList);
        this.setLoadBalancerType(new LoadBalancerDefinition(weighted));
        return this;
    }

    public LoadBalanceDefinition roundRobin() {
        this.setLoadBalancerType(new LoadBalancerDefinition(new RoundRobinLoadBalancer()));
        return this;
    }

    public LoadBalanceDefinition random() {
        this.setLoadBalancerType(new LoadBalancerDefinition(new RandomLoadBalancer()));
        return this;
    }

    public LoadBalanceDefinition custom(String ref) {
        CustomLoadBalancerDefinition balancer = new CustomLoadBalancerDefinition();
        balancer.setRef(ref);
        this.setLoadBalancerType(balancer);
        return this;
    }

    public LoadBalanceDefinition sticky(Expression correlationExpression) {
        this.setLoadBalancerType(new LoadBalancerDefinition(new StickyLoadBalancer(correlationExpression)));
        return this;
    }

    public LoadBalanceDefinition topic() {
        this.setLoadBalancerType(new LoadBalancerDefinition(new TopicLoadBalancer()));
        return this;
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        List<ProcessorDefinition> list = this.getOutputs();
        for (ProcessorDefinition processorType : list) {
            buffer.append(processorType.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.loadBalancerType != null) {
            return "LoadBalanceType[" + this.loadBalancerType + ", " + this.getOutputs() + "]";
        }
        return "LoadBalanceType[ref:" + this.ref + ", " + this.getOutputs() + "]";
    }
}

