/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

@XmlRootElement(name="wireTap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WireTapDefinition<Type extends ProcessorDefinition>
extends NoOutputDefinition
implements ExecutorServiceAwareDefinition<ProcessorDefinition> {
    @XmlAttribute
    protected String uri;
    @XmlAttribute
    protected String ref;
    @XmlTransient
    protected Endpoint endpoint;
    @XmlTransient
    private Processor newExchangeProcessor;
    @XmlAttribute(name="processorRef")
    private String newExchangeProcessorRef;
    @XmlElement(name="body")
    private ExpressionSubElementDefinition newExchangeExpression;
    @XmlElementRef
    private List<SetHeaderDefinition> headers = new ArrayList<SetHeaderDefinition>();
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean copy;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;

    public WireTapDefinition() {
    }

    public WireTapDefinition(String uri) {
        this.setUri(uri);
    }

    public WireTapDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "WireTap", this);
        if (this.executorService == null) {
            this.executorService = routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "WireTap");
        }
        WireTapProcessor answer = new WireTapProcessor(endpoint, this.getPattern(), this.executorService);
        answer.setCopy(this.isCopy());
        if (this.newExchangeProcessorRef != null) {
            this.newExchangeProcessor = routeContext.lookup(this.newExchangeProcessorRef, Processor.class);
        }
        if (this.newExchangeProcessor != null) {
            answer.addNewExchangeProcessor(this.newExchangeProcessor);
        }
        if (this.newExchangeExpression != null) {
            answer.setNewExchangeExpression(this.newExchangeExpression.createExpression(routeContext));
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (SetHeaderDefinition header : this.headers) {
                Processor processor = header.createProcessor(routeContext);
                answer.addNewExchangeProcessor(processor);
            }
        }
        if (this.onPrepareRef != null) {
            this.onPrepare = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onPrepareRef, Processor.class);
        }
        if (this.onPrepare != null) {
            answer.setOnPrepare(this.onPrepare);
        }
        return answer;
    }

    public ExchangePattern getPattern() {
        return ExchangePattern.InOnly;
    }

    public String toString() {
        return "WireTap[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "wireTap";
    }

    public Type end() {
        return (Type)super.end();
    }

    @Override
    public void addOutput(ProcessorDefinition output) {
        this.getParent().addOutput(output);
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            return context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    @Override
    public String getLabel() {
        return FromDefinition.description(this.getUri(), this.getRef(), this.getEndpoint());
    }

    @Override
    public WireTapDefinition<Type> executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public WireTapDefinition<Type> executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public WireTapDefinition<Type> copy() {
        this.setCopy(true);
        return this;
    }

    @Deprecated
    public WireTapDefinition<Type> newExchange(Expression expression) {
        return this.newExchangeBody(expression);
    }

    public WireTapDefinition<Type> newExchangeBody(Expression expression) {
        this.setNewExchangeExpression(expression);
        return this;
    }

    public WireTapDefinition<Type> newExchangeRef(String ref) {
        this.setNewExchangeProcessorRef(ref);
        return this;
    }

    public WireTapDefinition<Type> newExchange(Processor processor) {
        this.setNewExchangeProcessor(processor);
        return this;
    }

    public WireTapDefinition<Type> newExchangeHeader(String headerName, Expression expression) {
        this.headers.add(new SetHeaderDefinition(headerName, expression));
        return this;
    }

    public WireTapDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public WireTapDefinition<Type> onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor processor) {
        this.newExchangeProcessor = processor;
    }

    public String getNewExchangeProcessorRef() {
        return this.newExchangeProcessorRef;
    }

    public void setNewExchangeProcessorRef(String ref) {
        this.newExchangeProcessorRef = ref;
    }

    public ExpressionSubElementDefinition getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(ExpressionSubElementDefinition expression) {
        this.newExchangeExpression = expression;
    }

    public void setNewExchangeExpression(Expression expression) {
        this.newExchangeExpression = new ExpressionSubElementDefinition(expression);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public boolean isCopy() {
        return this.copy != null ? this.copy : true;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public List<SetHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SetHeaderDefinition> headers) {
        this.headers = headers;
    }
}

