/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="xpath")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XPathExpression
extends NamespaceAwareExpression {
    @XmlAttribute(name="resultType")
    private String resultTypeName;
    @XmlTransient
    private Class<?> resultType;

    public XPathExpression() {
    }

    public XPathExpression(String expression) {
        super(expression);
    }

    public XPathExpression(Expression expression) {
        this.setExpressionValue(expression);
    }

    @Override
    public String getLanguage() {
        return "xpath";
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.resultType == null && this.resultTypeName != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createExpression(camelContext);
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        super.configureExpression(camelContext, expression);
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        super.configurePredicate(camelContext, predicate);
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
    }
}

