/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;

public class UseLatestAggregationStrategy
implements AggregationStrategy {
    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        Exchange answer = null;
        this.propagateException(oldExchange, newExchange);
        if (newExchange.getException() != null) {
            answer = newExchange;
        }
        if (answer == null) {
            answer = this.propagateFailure(oldExchange, newExchange);
        }
        return answer;
    }

    protected void propagateException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return;
        }
        if (newExchange.getException() == null) {
            newExchange.setException(oldExchange.getException());
        }
    }

    protected Exchange propagateFailure(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler(oldExchange);
        if (oldExchange.isFailed() || oldExchange.isRollbackOnly() || exceptionHandled) {
            return oldExchange;
        }
        return newExchange;
    }

    public String toString() {
        return "UseLatestAggregationStrategy";
    }
}

