/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.AggregateRouteNode;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultRouteNode;
import org.apache.camel.impl.DoCatchRouteNode;
import org.apache.camel.impl.DoFinallyRouteNode;
import org.apache.camel.impl.OnCompletionRouteNode;
import org.apache.camel.impl.OnExceptionRouteNode;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceInterceptor
extends DelegateAsyncProcessor
implements ExchangeFormatter {
    private static final transient Logger LOG = LoggerFactory.getLogger(TraceInterceptor.class);
    private CamelLogger logger;
    private Producer traceEventProducer;
    private final ProcessorDefinition node;
    private final Tracer tracer;
    private TraceFormatter formatter;
    private Class<?> jpaTraceEventMessageClass;
    private RouteContext routeContext;
    private TraceEventHandler traceHandler;
    private String jpaTraceEventMessageClassName;

    public TraceInterceptor(ProcessorDefinition node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogger(this);
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
        this.traceHandler = tracer.getTraceHandler();
        this.jpaTraceEventMessageClassName = tracer.getJpaTraceEventMessageClassName();
    }

    @Override
    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (!this.tracer.isEnabled() || this.routeContext != null && !this.routeContext.isTracing().booleanValue()) {
            return super.process(exchange, callback);
        }
        if (exchange.getProperty("CamelTraceEvent", false, Boolean.class).booleanValue()) {
            return super.process(exchange, callback);
        }
        final boolean shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
        boolean trace = true;
        boolean sync = true;
        try {
            if (shouldLog) {
                if (exchange.getUnitOfWork() != null) {
                    TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
                    if (this.node instanceof OnCompletionDefinition || this.node instanceof OnExceptionDefinition) {
                        trace = false;
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnCompletionDefinition.class, this.node)) {
                        this.traceOnCompletion(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnExceptionDefinition.class, this.node)) {
                        this.traceOnException(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(CatchDefinition.class, this.node)) {
                        this.traceDoCatch(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(FinallyDefinition.class, this.node)) {
                        this.traceDoFinally(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(AggregateDefinition.class, this.node)) {
                        this.traceAggregate(traced, exchange);
                    } else {
                        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
                    }
                } else {
                    LOG.trace("Cannot trace as this Exchange does not have an UnitOfWork: {}", (Object)exchange);
                }
            }
            Object state = null;
            if (shouldLog && trace) {
                this.logExchange(exchange);
                if (this.tracer.isTraceOutExchanges()) {
                    state = this.traceExchangeIn(exchange);
                } else {
                    this.traceExchange(exchange);
                }
            }
            final Object traceState = state;
            if (this.node.getParent() instanceof InterceptDefinition && exchange.getUnitOfWork() != null) {
                TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
                this.traceIntercept((InterceptDefinition)this.node.getParent(), traced, exchange);
            }
            sync = super.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean doneSync) {
                    try {
                        if (shouldLog && TraceInterceptor.this.tracer.isTraceOutExchanges()) {
                            TraceInterceptor.this.logExchange(exchange);
                            TraceInterceptor.this.traceExchangeOut(exchange, traceState);
                        }
                    }
                    catch (Throwable e) {
                        if (TraceInterceptor.this.shouldLogException(exchange)) {
                            TraceInterceptor.this.logException(exchange, e);
                        }
                        exchange.setException(e);
                    }
                    finally {
                        callback.done(doneSync);
                    }
                }
            });
        }
        catch (Throwable e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            exchange.setException(e);
        }
        return sync;
    }

    private void traceOnCompletion(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new OnCompletionRouteNode());
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceOnException(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new OnExceptionRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoCatch(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new DoCatchRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoFinally(TracedRouteNodes traced, Exchange exchange) throws Exception {
        if (traced.getLastNode() != null) {
            traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        }
        traced.addTraced(new DoFinallyRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceAggregate(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new AggregateRouteNode((AggregateDefinition)this.node.getParent()));
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    protected void traceIntercept(InterceptDefinition intercept, TracedRouteNodes traced, Exchange exchange) throws Exception {
        Processor last = intercept.getInterceptedProcessor(traced.getAndIncrementCounter(intercept));
        if (last != null) {
            boolean shouldLog;
            traced.addTraced(new DefaultRouteNode(this.node, last));
            boolean bl = shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
            if (shouldLog) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
    }

    @Override
    public String format(Exchange exchange) {
        Object msg = this.formatter.format(this, this.getNode(), exchange);
        if (msg != null) {
            return msg.toString();
        }
        return null;
    }

    public ProcessorDefinition<?> getNode() {
        return this.node;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public TraceEventHandler getTraceHandler() {
        return this.traceHandler;
    }

    public void setTraceHandler(TraceEventHandler traceHandler) {
        this.traceHandler = traceHandler;
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    protected void traceExchange(Exchange exchange) throws Exception {
        if (this.traceHandler != null) {
            this.traceHandler.traceExchange(this.node, this.processor, this, exchange);
        } else if (this.tracer.getDestination() != null || this.tracer.getDestinationUri() != null) {
            Date timestamp = new Date();
            DefaultExchange event = new DefaultExchange(exchange);
            event.setProperty("CamelTraceEventNodeId", this.node.getId());
            event.setProperty("CamelTraceEventTimestamp", timestamp);
            event.setProperty("CamelTraceEventExchange", exchange);
            DefaultTraceEventMessage msg = new DefaultTraceEventMessage(timestamp, this.node, exchange);
            if (this.tracer.isUseJpa()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Using class: " + this.jpaTraceEventMessageClassName + " for tracing event messages");
                }
                this.loadJpaTraceEventMessageClass(exchange);
                Object jpa = ObjectHelper.newInstance(this.jpaTraceEventMessageClass);
                HashMap<String, Object> options = new HashMap<String, Object>();
                IntrospectionSupport.getProperties(msg, options, null);
                IntrospectionSupport.setProperties(jpa, options);
                IntrospectionSupport.setProperty(jpa, "timestamp", msg.getTimestamp());
                event.getIn().setBody(jpa);
            } else {
                event.getIn().setBody(msg);
            }
            event.setProperty("CamelTraceEvent", Boolean.TRUE);
            try {
                this.getTraceEventProducer(exchange).process(event);
            }
            catch (Exception e) {
                LOG.error("Error processing trace event (original Exchange will continue): " + event, (Throwable)e);
            }
        }
    }

    private synchronized void loadJpaTraceEventMessageClass(Exchange exchange) {
        if (this.jpaTraceEventMessageClass == null) {
            this.jpaTraceEventMessageClass = exchange.getContext().getClassResolver().resolveClass(this.jpaTraceEventMessageClassName);
            if (this.jpaTraceEventMessageClass == null) {
                throw new IllegalArgumentException("Cannot find class: " + this.jpaTraceEventMessageClassName + ". Make sure camel-jpa.jar is in the classpath.");
            }
        }
    }

    protected Object traceExchangeIn(Exchange exchange) throws Exception {
        if (this.traceHandler != null) {
            return this.traceHandler.traceExchangeIn(this.node, this.processor, this, exchange);
        }
        this.traceExchange(exchange);
        return null;
    }

    protected void traceExchangeOut(Exchange exchange, Object traceState) throws Exception {
        if (this.traceHandler != null) {
            this.traceHandler.traceExchangeOut(this.node, this.processor, this, exchange, traceState);
        } else {
            this.traceExchange(exchange);
        }
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            if (this.tracer.isLogStackTrace()) {
                this.logger.process(exchange, throwable);
            } else {
                this.logger.process(exchange, ", Exception: " + throwable.toString());
            }
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.tracer.isEnabled() && (this.tracer.getTraceFilter() == null || this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    public boolean shouldTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    protected boolean shouldLogNode(ProcessorDefinition<?> node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy);
    }

    private synchronized Producer getTraceEventProducer(Exchange exchange) throws Exception {
        if (this.traceEventProducer == null) {
            Endpoint endpoint = this.tracer.getDestination() != null ? this.tracer.getDestination() : exchange.getContext().getEndpoint(this.tracer.getDestinationUri());
            this.traceEventProducer = endpoint.createProducer();
            ServiceHelper.startService(this.traceEventProducer);
        }
        return this.traceEventProducer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.traceEventProducer = null;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.traceEventProducer != null) {
            ServiceHelper.stopService(this.traceEventProducer);
        }
    }
}

