/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NodeList;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static Integer size(Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.size();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return map.size();
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                return array.length;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            if (value instanceof NodeList) {
                NodeList nodeList = (NodeList)value;
                return nodeList.getLength();
            }
        }
        return null;
    }

    public static void appendValue(Map map, Object key, Object value) {
        Object oldValue = map.get(key);
        if (oldValue != null) {
            ArrayList<Object> list;
            if (oldValue instanceof List) {
                list = (ArrayList<Object>)oldValue;
            } else {
                list = new ArrayList<Object>();
                list.add(oldValue);
                map.remove(key);
                map.put(key, list);
            }
            list.add(value);
        } else {
            map.put(key, value);
        }
    }

    public static <T> Set<T> createSetContaining(T ... contents) {
        HashSet<T> contentsAsSet = new HashSet<T>();
        contentsAsSet.addAll(Arrays.asList(contents));
        return contentsAsSet;
    }

    public static String collectionAsCommaDelimitedString(String[] col) {
        if (col == null || col.length == 0) {
            return "";
        }
        return CollectionHelper.collectionAsCommaDelimitedString(Arrays.asList(col));
    }

    public static String collectionAsCommaDelimitedString(Collection<?> col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = col.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

