/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message) {
        Object answer;
        if (message == null) {
            return null;
        }
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message) {
        if (message == null) {
            return;
        }
        if (message.getBody() instanceof StreamCache) {
            ((StreamCache)message.getBody()).reset();
        }
    }

    public static String getContentType(Message message) {
        return message.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message) {
        return message.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message) {
        return MessageHelper.extractBodyForLogging(message, "Message: ");
    }

    public static String extractBodyForLogging(Message message, String prepend) {
        String property;
        String property2;
        boolean streams = false;
        if (message.getExchange() != null && (property2 = message.getExchange().getContext().getProperties().get("CamelLogDebugStreams")) != null) {
            streams = message.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, property2);
        }
        int maxChars = 1000;
        if (message.getExchange() != null && (property = message.getExchange().getContext().getProperties().get("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        return MessageHelper.extractBodyForLogging(message, prepend, streams, false, maxChars);
    }

    public static String extractBodyForLogging(Message message, String prepend, boolean allowStreams, boolean allowFiles, int maxChars) {
        Object obj = message.getBody();
        if (obj == null) {
            return prepend + "[Body is null]";
        }
        if (!(obj instanceof StringSource) && !(obj instanceof BytesSource)) {
            if (!allowStreams && obj instanceof StreamCache) {
                return prepend + "[Body is instance of org.apache.camel.StreamCache]";
            }
            if (!allowStreams && obj instanceof StreamSource) {
                return prepend + "[Body is instance of java.xml.transform.StreamSource]";
            }
            if (!allowStreams && obj instanceof InputStream) {
                return prepend + "[Body is instance of java.io.InputStream]";
            }
            if (!allowStreams && obj instanceof OutputStream) {
                return prepend + "[Body is instance of java.io.OutputStream]";
            }
            if (!allowStreams && obj instanceof Reader) {
                return prepend + "[Body is instance of java.io.Reader]";
            }
            if (!allowStreams && obj instanceof Writer) {
                return prepend + "[Body is instance of java.io.Writer]";
            }
            if (!allowFiles && (obj instanceof GenericFile || obj instanceof File)) {
                return prepend + "[Body is file based: " + obj + "]";
            }
        }
        StreamCache cache = obj instanceof StreamCache ? (StreamCache)obj : null;
        String body = null;
        if (message.getExchange() != null) {
            try {
                body = message.getExchange().getContext().getTypeConverter().convertTo(String.class, obj);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (body == null) {
            body = obj.toString();
        }
        if (cache != null) {
            cache.reset();
        }
        if (body == null) {
            return prepend + "[Body is null]";
        }
        if (maxChars > 0 && body.length() > maxChars) {
            body = body.substring(0, maxChars) + "... [Body clipped after " + maxChars + " chars, total length is " + body.length() + "]";
        }
        return prepend + body;
    }

    public static String dumpAsXml(Message message) {
        return MessageHelper.dumpAsXml(message, true);
    }

    public static String dumpAsXml(Message message, boolean includeBody) {
        StringBuilder sb = new StringBuilder();
        sb.append("<message exchangeId=\"").append(message.getExchange().getExchangeId()).append("\">\n");
        if (message.hasHeaders()) {
            sb.append("<headers>\n");
            TreeMap<String, Object> headers = new TreeMap<String, Object>(message.getHeaders());
            for (Map.Entry entry : headers.entrySet()) {
                Object value = entry.getValue();
                String type = ObjectHelper.classCanonicalName(value);
                sb.append("<header key=\"" + (String)entry.getKey() + "\"");
                if (type != null) {
                    sb.append(" type=\"" + type + "\"");
                }
                sb.append(">");
                if (value != null) {
                    try {
                        String xml = message.getExchange().getContext().getTypeConverter().convertTo(String.class, value);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode(xml));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append("</headers>\n");
        }
        if (includeBody) {
            sb.append("<body");
            String type = ObjectHelper.classCanonicalName(message.getBody());
            if (type != null) {
                sb.append(" type=\"" + type + "\"");
            }
            sb.append(">");
            String xml = MessageHelper.extractBodyForLogging(message, "", false, true, 131072);
            if (xml != null) {
                sb.append(StringHelper.xmlEncode(xml));
            }
            sb.append("</body>\n");
        }
        sb.append("</message>");
        return sb.toString();
    }

    public static void copyHeaders(Message source, Message target, boolean override) {
        if (!source.hasHeaders()) {
            return;
        }
        for (Map.Entry<String, Object> entry : source.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (target.getHeader(key) != null && !override) continue;
            target.setHeader(key, value);
        }
    }
}

