/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc;

import java.util.Hashtable;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.aries.transaction.jdbc.XADatasourceEnlistingWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer,
ServiceListener {
    private TransactionManager tm;
    private ServiceTracker t;
    private ServiceReference ref;
    private BundleContext context;

    public void start(BundleContext ctx) {
        this.context = ctx;
        this.t = new ServiceTracker(ctx, XADataSource.class.getName(), (ServiceTrackerCustomizer)this);
        try {
            ctx.addServiceListener((ServiceListener)this, "(objectClass=javax.transaction.TransactionManager)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.ref = ctx.getServiceReference(TransactionManager.class.getName());
        if (this.ref != null) {
            this.tm = (TransactionManager)ctx.getService(this.ref);
        }
        if (this.tm != null) {
            this.t.open();
        }
    }

    public void stop(BundleContext ctx) {
        if (this.t != null) {
            this.t.close();
        }
        if (this.ref != null) {
            this.context.ungetService(this.ref);
        }
    }

    public Object addingService(ServiceReference ref) {
        BundleContext ctx = ref.getBundle().getBundleContext();
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        for (String key : ref.getPropertyKeys()) {
            map.put(key, ref.getProperty(key));
        }
        map.put("aries.xa.aware", "true");
        XADatasourceEnlistingWrapper wrapper = new XADatasourceEnlistingWrapper();
        wrapper.setTxManager(this.tm);
        wrapper.setDataSource((XADataSource)ctx.getService(ref));
        ServiceRegistration reg = ctx.registerService(DataSource.class.getName(), (Object)wrapper, map);
        return reg;
    }

    public void modifiedService(ServiceReference ref, Object service) {
        ServiceRegistration reg = (ServiceRegistration)service;
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        for (String key : ref.getPropertyKeys()) {
            map.put(key, ref.getProperty(key));
        }
        map.put("aries.xa.aware", "true");
        reg.setProperties(map);
    }

    public void removedService(ServiceReference ref, Object service) {
        ((ServiceRegistration)service).unregister();
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && this.tm == null) {
            this.ref = event.getServiceReference();
            this.tm = (TransactionManager)this.context.getService(this.ref);
            if (this.tm == null) {
                this.ref = null;
            } else {
                this.t.open();
            }
        } else if (event.getType() == 4 && this.tm != null && this.ref.getProperty("service.id").equals(event.getServiceReference().getProperty("service.id"))) {
            this.t.close();
            this.context.ungetService(this.ref);
            this.ref = null;
            this.tm = null;
        }
    }
}

