/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.config.DefaultConfiguration;
import java.util.Map;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.RobustInOnly;
import org.apache.servicemix.osworkflow.OSWorkflowEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSWorkflow
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(OSWorkflow.class);
    public static final String KEY_EXCHANGE = "exchange";
    public static final String KEY_IN_MESSAGE = "in-message";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_CALLER = "caller";
    public static final String KEY_ASYNC_PROCESSING = "asynchronous";
    private Workflow osWorkflowInstance;
    private String caller;
    private String osWorkflowName;
    private Map map;
    private int action = -1;
    private long workflowId = -1L;
    private boolean finished;
    private boolean aborted;
    private OSWorkflowEndpoint endpoint;
    private MessageExchange exchange;

    public OSWorkflow(OSWorkflowEndpoint ep, String workflowName, int action, Map map, String caller, MessageExchange exchange) {
        this.endpoint = ep;
        this.osWorkflowName = workflowName;
        this.osWorkflowInstance = null;
        this.action = action;
        this.map = map;
        this.caller = caller;
        this.exchange = exchange;
        this.map.put(KEY_ENDPOINT, this.endpoint);
        this.map.put(KEY_CALLER, this.caller);
        this.map.put(KEY_IN_MESSAGE, this.exchange.getMessage("in"));
        this.map.put(KEY_EXCHANGE, this.exchange);
        this.map.put(KEY_ASYNC_PROCESSING, this.exchange instanceof InOnly || this.exchange instanceof RobustInOnly);
    }

    private long createWorkflow() throws InvalidRoleException, InvalidInputException, WorkflowException {
        this.osWorkflowInstance = new BasicWorkflow(this.caller);
        DefaultConfiguration config = new DefaultConfiguration();
        this.osWorkflowInstance.setConfiguration((Configuration)config);
        long wfId = this.osWorkflowInstance.initialize(this.osWorkflowName, this.action, this.map);
        return wfId;
    }

    public void run() {
        this.endpoint.preWorkflow();
        this.logger.debug("Starting workflow...");
        this.logger.debug("Name:       {}", (Object)this.osWorkflowName);
        this.logger.debug("Action:     {}", (Object)this.action);
        this.logger.debug("Caller:     {}", (Object)this.caller);
        this.logger.debug("Map:        {}", (Object)this.map);
        while (!this.finished && !this.aborted) {
            int[] availableActions;
            if (this.osWorkflowInstance == null) {
                try {
                    this.workflowId = this.createWorkflow();
                }
                catch (Exception ex) {
                    this.logger.error("Error creating the workflow", (Throwable)ex);
                    this.aborted = true;
                    break;
                }
            }
            if ((availableActions = this.osWorkflowInstance.getAvailableActions(this.workflowId, this.map)).length == 0) {
                this.logger.debug("No more actions. Workflow is finished...");
                this.finished = true;
                continue;
            }
            int nextAction = availableActions[0];
            this.logger.debug("call action " + nextAction);
            try {
                this.osWorkflowInstance.doAction(this.workflowId, nextAction, this.map);
            }
            catch (InvalidInputException iiex) {
                this.logger.error(iiex.getMessage());
                this.aborted = true;
            }
            catch (WorkflowException wfex) {
                this.logger.error(wfex.getMessage());
                this.aborted = true;
            }
        }
        this.logger.debug("Stopping workflow...");
        this.logger.debug("Name:       {}", (Object)this.osWorkflowName);
        this.logger.debug("Action:     {}", (Object)this.action);
        this.logger.debug("Caller:     {}", (Object)this.caller);
        this.logger.debug("Map:        {}", (Object)this.map);
        this.logger.debug("WorkflowId: {}", (Object)this.workflowId);
        this.logger.debug("End state:  {}", (Object)(this.finished ? "Finished" : "Aborted"));
        this.endpoint.postWorkflow();
    }
}

