/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.jar.Manifest;
import org.apache.xbean.classloader.AbstractUrlResourceLocation;
import org.apache.xbean.classloader.DirectoryResourceHandle;
import org.apache.xbean.classloader.IoUtil;
import org.apache.xbean.classloader.ResourceHandle;

public class DirectoryResourceLocation
extends AbstractUrlResourceLocation {
    private final File baseDir;
    private boolean manifestLoaded = false;
    private Manifest manifest;

    public DirectoryResourceLocation(File baseDir) throws MalformedURLException {
        super(baseDir.toURI().toURL());
        this.baseDir = baseDir;
    }

    public ResourceHandle getResourceHandle(String resourceName) {
        File file = new File(this.baseDir, resourceName);
        if (!file.exists()) {
            return null;
        }
        try {
            DirectoryResourceHandle resourceHandle = new DirectoryResourceHandle(resourceName, file, this.baseDir, this.getManifestSafe());
            return resourceHandle;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File manifestFile = new File(this.baseDir, "META-INF/MANIFEST.MF");
            if (manifestFile.isFile() && manifestFile.canRead()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(manifestFile);
                    this.manifest = new Manifest(in);
                }
                catch (Throwable throwable) {
                    IoUtil.close(in);
                    throw throwable;
                }
                IoUtil.close(in);
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }
}

