/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.descriptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.servicemix.jbi.deployer.descriptor.ClassPath;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Connection;
import org.apache.servicemix.jbi.deployer.descriptor.Connections;
import org.apache.servicemix.jbi.deployer.descriptor.Consumer;
import org.apache.servicemix.jbi.deployer.descriptor.Consumes;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.Identification;
import org.apache.servicemix.jbi.deployer.descriptor.InstallationDescriptorExtension;
import org.apache.servicemix.jbi.deployer.descriptor.Provider;
import org.apache.servicemix.jbi.deployer.descriptor.Provides;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Services;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryList;
import org.apache.servicemix.jbi.deployer.descriptor.Target;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorFactory {
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    public static final String DESCRIPTOR_FILE = "META-INF/jbi.xml";
    private static final String VERSION = "version";
    private static final String TYPE = "type";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_CLASS_LOADER_DELEGATION = "component-class-loader-delegation";
    private static final String BOOTSTRAP_CLASS_LOADER_DELEGATION = "bootstrap-class-loader-delegation";
    private static final String DESCRIPTION = "description";
    private static final String IDENTIFICATION = "identification";
    private static final String COMPONENT_CLASS_NAME = "component-class-name";
    private static final String COMPONENT_CLASS_PATH = "component-class-path";
    private static final String PATH_ELEMENT = "path-element";
    private static final String SHARED_LIBRARY = "shared-library";
    private static final String BOOTSTRAP_CLASS_PATH = "bootstrap-class-path";
    private static final String BOOTSTRAP_CLASS_NAME = "bootstrap-class-name";
    private static final String CLASS_LOADER_DELEGATION = "class-loader-delegation";
    private static final String SERVICE_ASSEMBLY = "service-assembly";
    private static final String SERVICE_UNIT = "service-unit";
    private static final String TARGET = "target";
    private static final String ARTIFACTS_ZIP = "artifacts-zip";
    private static final String COMPONENT_NAME = "component-name";
    private static final String CONNECTIONS = "connections";
    private static final String CONNECTION = "connection";
    private static final String CONSUMER = "consumer";
    private static final String PROVIDER = "provider";
    private static final String INTERFACE_NAME = "interface-name";
    private static final String SERVICE_NAME = "service-name";
    private static final String ENDPOINT_NAME = "endpoint-name";
    private static final String BINDING_COMPONENT = "binding-component";
    private static final String SERVICES = "services";
    private static final String PROVIDES = "provides";
    private static final String CONSUMES = "consumes";
    private static final String LINK_TYPE = "link-type";
    private static final String NAME = "name";
    private static final String JBI_DESCRIPTOR_XSD = "jbi-descriptor.xsd";
    private static final String SHARED_LIBRARY_CLASS_PATH = "shared-library-class-path";

    public static Descriptor buildDescriptor(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                return DescriptorFactory.buildDescriptor(descriptorFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("There is a bug here...", e);
            }
        }
        return null;
    }

    public static Descriptor buildDescriptor(URL url) {
        try {
            return DescriptorFactory.buildDescriptor(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Descriptor buildDescriptor(InputStream stream) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DescriptorFactory.copyInputStream(stream, baos);
            return DescriptorFactory.buildDescriptor(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Descriptor buildDescriptor(byte[] bytes) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(XSD_SCHEMA_LANGUAGE);
            Schema schema = schemaFactory.newSchema(DescriptorFactory.class.getResource(JBI_DESCRIPTOR_XSD));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            validator.validate(new StreamSource(new ByteArrayInputStream(bytes)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(bytes));
            Element jbi = doc.getDocumentElement();
            Descriptor desc = new Descriptor();
            desc.setVersion(Double.parseDouble(DescriptorFactory.getAttribute(jbi, VERSION)));
            Element child = DescriptorFactory.getFirstChildElement(jbi);
            if (COMPONENT.equals(child.getLocalName())) {
                ComponentDesc component = new ComponentDesc();
                component.setType(child.getAttribute(TYPE));
                component.setComponentClassLoaderDelegation(DescriptorFactory.getAttribute(child, COMPONENT_CLASS_LOADER_DELEGATION));
                component.setBootstrapClassLoaderDelegation(DescriptorFactory.getAttribute(child, BOOTSTRAP_CLASS_LOADER_DELEGATION));
                ArrayList<SharedLibraryList> sls = new ArrayList<SharedLibraryList>();
                DocumentFragment ext = null;
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    Element e2;
                    ArrayList<String> l;
                    if (IDENTIFICATION.equals(e.getLocalName())) {
                        component.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if (COMPONENT_CLASS_NAME.equals(e.getLocalName())) {
                        component.setComponentClassName(DescriptorFactory.getText(e));
                        component.setDescription(DescriptorFactory.getAttribute(e, DESCRIPTION));
                    } else if (COMPONENT_CLASS_PATH.equals(e.getLocalName())) {
                        ClassPath componentClassPath = new ClassPath();
                        l = new ArrayList<String>();
                        e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if (PATH_ELEMENT.equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        componentClassPath.setPathList(l);
                        component.setComponentClassPath(componentClassPath);
                    } else if (BOOTSTRAP_CLASS_NAME.equals(e.getLocalName())) {
                        component.setBootstrapClassName(DescriptorFactory.getText(e));
                    } else if (BOOTSTRAP_CLASS_PATH.equals(e.getLocalName())) {
                        ClassPath bootstrapClassPath = new ClassPath();
                        l = new ArrayList();
                        e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if (PATH_ELEMENT.equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        bootstrapClassPath.setPathList(l);
                        component.setBootstrapClassPath(bootstrapClassPath);
                    } else if (SHARED_LIBRARY.equals(e.getLocalName())) {
                        SharedLibraryList sl = new SharedLibraryList();
                        sl.setName(DescriptorFactory.getText(e));
                        sl.setVersion(DescriptorFactory.getAttribute(e, VERSION));
                        sls.add(sl);
                    } else {
                        if (ext == null) {
                            ext = doc.createDocumentFragment();
                        }
                        ext.appendChild(e);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                component.setSharedLibraries(sls.toArray(new SharedLibraryList[sls.size()]));
                if (ext != null) {
                    InstallationDescriptorExtension descriptorExtension = new InstallationDescriptorExtension();
                    descriptorExtension.setDescriptorExtension(ext);
                    component.setDescriptorExtension(descriptorExtension);
                }
                desc.setComponent(component);
            } else if (SHARED_LIBRARY.equals(child.getLocalName())) {
                SharedLibraryDesc sharedLibrary = new SharedLibraryDesc();
                sharedLibrary.setClassLoaderDelegation(DescriptorFactory.getAttribute(child, CLASS_LOADER_DELEGATION));
                sharedLibrary.setVersion(DescriptorFactory.getAttribute(child, VERSION));
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if (IDENTIFICATION.equals(e.getLocalName())) {
                        sharedLibrary.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if (SHARED_LIBRARY_CLASS_PATH.equals(e.getLocalName())) {
                        ClassPath sharedLibraryClassPath = new ClassPath();
                        ArrayList<String> l = new ArrayList<String>();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if (PATH_ELEMENT.equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        sharedLibraryClassPath.setPathList(l);
                        sharedLibrary.setSharedLibraryClassPath(sharedLibraryClassPath);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                desc.setSharedLibrary(sharedLibrary);
            } else if (SERVICE_ASSEMBLY.equals(child.getLocalName())) {
                ServiceAssemblyDesc serviceAssembly = new ServiceAssemblyDesc();
                ArrayList<ServiceUnitDesc> sus = new ArrayList<ServiceUnitDesc>();
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if (IDENTIFICATION.equals(e.getLocalName())) {
                        serviceAssembly.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if (SERVICE_UNIT.equals(e.getLocalName())) {
                        ServiceUnitDesc su = new ServiceUnitDesc();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if (IDENTIFICATION.equals(e2.getLocalName())) {
                                su.setIdentification(DescriptorFactory.readIdentification(e2));
                            } else if (TARGET.equals(e2.getLocalName())) {
                                Target target = new Target();
                                Element e3 = DescriptorFactory.getFirstChildElement(e2);
                                while (e3 != null) {
                                    if (ARTIFACTS_ZIP.equals(e3.getLocalName())) {
                                        target.setArtifactsZip(DescriptorFactory.getText(e3));
                                    } else if (COMPONENT_NAME.equals(e3.getLocalName())) {
                                        target.setComponentName(DescriptorFactory.getText(e3));
                                    }
                                    e3 = DescriptorFactory.getNextSiblingElement(e3);
                                }
                                su.setTarget(target);
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        sus.add(su);
                    } else if (CONNECTIONS.equals(e.getLocalName())) {
                        Connections connections = new Connections();
                        ArrayList<Connection> cns = new ArrayList<Connection>();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if (CONNECTION.equals(e2.getLocalName())) {
                                Connection cn = new Connection();
                                Element e3 = DescriptorFactory.getFirstChildElement(e2);
                                while (e3 != null) {
                                    if (CONSUMER.equals(e3.getLocalName())) {
                                        Consumer consumer = new Consumer();
                                        consumer.setInterfaceName(DescriptorFactory.readAttributeQName(e3, INTERFACE_NAME));
                                        consumer.setServiceName(DescriptorFactory.readAttributeQName(e3, SERVICE_NAME));
                                        consumer.setEndpointName(DescriptorFactory.getAttribute(e3, ENDPOINT_NAME));
                                        cn.setConsumer(consumer);
                                    } else if (PROVIDER.equals(e3.getLocalName())) {
                                        Provider provider = new Provider();
                                        provider.setServiceName(DescriptorFactory.readAttributeQName(e3, SERVICE_NAME));
                                        provider.setEndpointName(DescriptorFactory.getAttribute(e3, ENDPOINT_NAME));
                                        cn.setProvider(provider);
                                    }
                                    e3 = DescriptorFactory.getNextSiblingElement(e3);
                                }
                                cns.add(cn);
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        connections.setConnections(cns.toArray(new Connection[cns.size()]));
                        serviceAssembly.setConnections(connections);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                serviceAssembly.setServiceUnits(sus.toArray(new ServiceUnitDesc[sus.size()]));
                desc.setServiceAssembly(serviceAssembly);
            } else if (SERVICES.equals(child.getLocalName())) {
                Services services = new Services();
                services.setBindingComponent(Boolean.valueOf(DescriptorFactory.getAttribute(child, BINDING_COMPONENT)));
                ArrayList<Provides> provides = new ArrayList<Provides>();
                ArrayList<Consumes> consumes = new ArrayList<Consumes>();
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if (PROVIDES.equals(e.getLocalName())) {
                        Provides p = new Provides();
                        p.setInterfaceName(DescriptorFactory.readAttributeQName(e, INTERFACE_NAME));
                        p.setServiceName(DescriptorFactory.readAttributeQName(e, SERVICE_NAME));
                        p.setEndpointName(DescriptorFactory.getAttribute(e, ENDPOINT_NAME));
                        provides.add(p);
                    } else if (CONSUMES.equals(e.getLocalName())) {
                        Consumes c = new Consumes();
                        c.setInterfaceName(DescriptorFactory.readAttributeQName(e, INTERFACE_NAME));
                        c.setServiceName(DescriptorFactory.readAttributeQName(e, SERVICE_NAME));
                        c.setEndpointName(DescriptorFactory.getAttribute(e, ENDPOINT_NAME));
                        c.setLinkType(DescriptorFactory.getAttribute(e, LINK_TYPE));
                        consumes.add(c);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                services.setProvides(provides.toArray(new Provides[provides.size()]));
                services.setConsumes(consumes.toArray(new Consumes[consumes.size()]));
                desc.setServices(services);
            }
            DescriptorFactory.checkDescriptor(desc);
            return desc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAttribute(Element e, String name) {
        if (e.hasAttribute(name)) {
            return e.getAttribute(name);
        }
        return null;
    }

    private static QName readAttributeQName(Element e, String name) {
        String attr = DescriptorFactory.getAttribute(e, name);
        if (attr != null) {
            return DescriptorFactory.createQName(e, attr);
        }
        return null;
    }

    private static String getText(Element e) {
        return DescriptorFactory.getElementText(e).trim();
    }

    private static Identification readIdentification(Element e) {
        Identification ident = new Identification();
        Element e2 = DescriptorFactory.getFirstChildElement(e);
        while (e2 != null) {
            if (NAME.equals(e2.getLocalName())) {
                ident.setName(DescriptorFactory.getElementText(e2));
            } else if (DESCRIPTION.equals(e2.getLocalName())) {
                ident.setDescription(DescriptorFactory.getElementText(e2));
            }
            e2 = DescriptorFactory.getNextSiblingElement(e2);
        }
        return ident;
    }

    public static void checkDescriptor(Descriptor descriptor) {
        ArrayList<String> violations = new ArrayList<String>();
        if (descriptor.getVersion() != 1.0) {
            violations.add("JBI descriptor version should be set to '1.0' but is " + descriptor.getVersion());
        }
        if (descriptor.getComponent() != null) {
            DescriptorFactory.checkComponent(violations, descriptor.getComponent());
        } else if (descriptor.getServiceAssembly() != null) {
            DescriptorFactory.checkServiceAssembly(violations, descriptor.getServiceAssembly());
        } else if (descriptor.getServices() != null) {
            DescriptorFactory.checkServiceUnit(violations, descriptor.getServices());
        } else if (descriptor.getSharedLibrary() != null) {
            DescriptorFactory.checkSharedLibrary(violations, descriptor.getSharedLibrary());
        } else {
            violations.add("The jbi descriptor does not contain any informations");
        }
        if (violations.size() > 0) {
            throw new RuntimeException("The JBI descriptor is not valid, please correct these violations " + ((Object)violations).toString());
        }
    }

    private static void checkComponent(List<String> violations, ComponentDesc component) {
        if (component.getIdentification() == null) {
            violations.add("The component has not identification");
        } else if (DescriptorFactory.isBlank(component.getIdentification().getName())) {
            violations.add("The component name is not set");
        }
        if (component.getBootstrapClassName() == null) {
            violations.add("The component has not defined a boot-strap class name");
        }
        if (component.getBootstrapClassPath() == null || component.getBootstrapClassPath().getPathElements() == null) {
            violations.add("The component has not defined any boot-strap class path elements");
        }
    }

    private static void checkServiceAssembly(List<String> violations, ServiceAssemblyDesc serviceAssembly) {
        if (serviceAssembly.getIdentification() == null) {
            violations.add("The service assembly has not identification");
        } else if (DescriptorFactory.isBlank(serviceAssembly.getIdentification().getName())) {
            violations.add("The service assembly name is not set");
        }
    }

    private static void checkServiceUnit(List<String> violations, Services services) {
    }

    private static void checkSharedLibrary(List<String> violations, SharedLibraryDesc sharedLibrary) {
        if (sharedLibrary.getIdentification() == null) {
            violations.add("The shared library has not identification");
        } else if (DescriptorFactory.isBlank(sharedLibrary.getIdentification().getName())) {
            violations.add("The shared library name is not set");
        }
    }

    public static String getDescriptorAsText(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                return DescriptorFactory.getDescriptorAsText(descriptorFile.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getDescriptorAsText(URL descriptorURL) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = descriptorURL.openStream();
            DescriptorFactory.copyInputStream(is, os);
            return os.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static QName createQName(Element element, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = DescriptorFactory.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            return new QName(uri, localName, prefix);
        }
        String uri = DescriptorFactory.recursiveGetAttributeValue(element, "xmlns");
        if (uri != null) {
            return new QName(uri, qualifiedName);
        }
        return new QName(qualifiedName);
    }

    public static String recursiveGetAttributeValue(Element element, String attributeName) {
        Node parentNode;
        String answer = null;
        try {
            answer = element.getAttribute(attributeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
            return DescriptorFactory.recursiveGetAttributeValue((Element)parentNode, attributeName);
        }
        return answer;
    }

    public static String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    public static Element getFirstChildElement(Node parent) {
        NodeList childs = parent.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element el) {
        for (Node n = el.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            return (Element)n;
        }
        return null;
    }
}

