/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.saxon;

import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.saxon.SaxonEndpoint;
import org.springframework.core.io.Resource;

public class XsltEndpoint
extends SaxonEndpoint {
    private TransformerFactory transformerFactory;
    private Source xsltSource;
    private Templates templates;
    private boolean useDomSourceForXslt = true;
    private Boolean useDomSourceForContent;

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public boolean isUseDomSourceForXslt() {
        return this.useDomSourceForXslt;
    }

    public void setUseDomSourceForXslt(boolean useDomSourceForXslt) {
        this.useDomSourceForXslt = useDomSourceForXslt;
    }

    public Boolean getUseDomSourceForContent() {
        return this.useDomSourceForContent;
    }

    public void setUseDomSourceForContent(Boolean useDomSourceForContent) {
        this.useDomSourceForContent = useDomSourceForContent;
    }

    public void validate() throws DeploymentException {
        if (this.xsltSource == null && this.getResource() == null && this.getExpression() == null) {
            throw new DeploymentException("xsltSource, resource or expression must be specified");
        }
    }

    protected void transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Transformer transformer = this.createTransformer(exchange, in);
        this.configureTransformer(transformer, exchange, in);
        this.transformContent(transformer, exchange, in, out);
    }

    protected void transformContent(Transformer transformer, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Source src = in.getContent();
        if (this.useDomSourceForContent != null && this.useDomSourceForContent.booleanValue()) {
            src = new DOMSource(this.getSourceTransformer().toDOMDocument(src));
        } else if (this.useDomSourceForContent != null && !this.useDomSourceForContent.booleanValue()) {
            src = this.getSourceTransformer().toStreamSource(src);
        } else if (src instanceof DOMSource) {
            src = new DOMSource(this.getSourceTransformer().toDOMDocument(src));
        }
        if ("bytes".equalsIgnoreCase(this.getResult())) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(src, result);
            out.setContent((Source)new BytesSource(buffer.toByteArray()));
        } else if ("string".equalsIgnoreCase(this.getResult())) {
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(src, result);
            out.setContent((Source)new StringSource(buffer.toString()));
        } else {
            DOMResult result = new DOMResult();
            transformer.transform(src, result);
            out.setContent((Source)new DOMSource(result.getNode()));
        }
    }

    protected Source getXsltSource() throws Exception {
        if (this.xsltSource == null) {
            this.xsltSource = this.createXsltSource(this.getResource());
        }
        return this.xsltSource;
    }

    protected Source createXsltSource(Resource res) throws Exception {
        String url = null;
        try {
            url = res.getURL().toURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.useDomSourceForXslt) {
            return new DOMSource(this.parse(res), url);
        }
        return new StreamSource(res.getInputStream(), url);
    }

    public synchronized Templates getTemplates() throws Exception {
        if (this.templates == null) {
            this.templates = this.createTemplates();
        }
        return this.templates;
    }

    protected Templates createTemplates() throws Exception {
        Source source = this.getXsltSource();
        return this.getTransformerFactory().newTemplates(source);
    }

    protected Transformer createTransformer(MessageExchange exchange, NormalizedMessage in) throws Exception {
        if (this.getExpression() != null) {
            Resource r = this.getDynamicResource(exchange, in);
            if (r == null) {
                return this.getTransformerFactory().newTransformer();
            }
            Source source = this.createXsltSource(r);
            return this.getTransformerFactory().newTransformer(source);
        }
        if (this.isReload()) {
            Source source = this.createXsltSource(this.getResource());
            return this.getTransformerFactory().newTransformer(source);
        }
        return this.getTemplates().newTransformer();
    }

    protected TransformerFactory createTransformerFactory() {
        if (this.getConfiguration() != null) {
            return new TransformerFactoryImpl(this.getConfiguration());
        }
        return new TransformerFactoryImpl();
    }

    protected void configureTransformer(Transformer transformer, MessageExchange exchange, NormalizedMessage in) {
        Object value;
        for (String name : exchange.getPropertyNames()) {
            value = exchange.getProperty(name);
            transformer.setParameter(name, value);
        }
        for (String name : in.getPropertyNames()) {
            value = in.getProperty(name);
            transformer.setParameter(name, value);
        }
        Map parameters = this.getParameters();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                Object value2 = parameters.get(name);
                transformer.setParameter(name, value2);
            }
        }
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", in);
        transformer.setParameter("component", (Object)this);
    }
}

