/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.CatalogXmlSchemaURIResolver;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtil {
    private final Map<String, Element> schemaList;
    private final Map<String, String> catalogResolved = new HashMap<String, String>();
    private final Bus bus;

    public SchemaUtil(Bus b, Map<String, Element> s) {
        this.bus = b;
        this.schemaList = s;
    }

    public void getSchemas(Definition def, ServiceInfo serviceInfo) {
        SchemaCollection schemaCol = serviceInfo.getXmlSchemaCollection();
        this.getSchemas(def, schemaCol, serviceInfo);
    }

    public void getSchemas(Definition def, SchemaCollection schemaCol, ServiceInfo serviceInfo) {
        this.getSchemas(def, schemaCol, serviceInfo.getSchemas());
    }

    public void getSchemas(Definition def, SchemaCollection schemaCol, List<SchemaInfo> schemas) {
        ArrayList<Definition> defList = new ArrayList<Definition>();
        this.parseImports(def, defList);
        this.extractSchema(def, schemaCol, schemas);
        this.getSchemaList(def);
        IdentityHashMap<Definition, Definition> done = new IdentityHashMap<Definition, Definition>();
        done.put(def, def);
        for (Definition def2 : defList) {
            if (done.containsKey(def2)) continue;
            this.extractSchema(def2, schemaCol, schemas);
            this.getSchemaList(def2);
            done.put(def2, def2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSchema(Definition def, SchemaCollection schemaCol, List<SchemaInfo> schemaInfos) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            int schemaCount = 1;
            for (Object obj : typesElement.getExtensibilityElements()) {
                Element elem;
                Element schemaElem = null;
                if (obj instanceof Schema) {
                    Schema schema = (Schema)obj;
                    schemaElem = schema.getElement();
                } else if (obj instanceof UnknownExtensibilityElement && (elem = ((UnknownExtensibilityElement)obj).getElement()).getLocalName().equals("schema")) {
                    schemaElem = elem;
                }
                if (schemaElem == null) continue;
                Document document = schemaElem.getOwnerDocument();
                synchronized (document) {
                    Map nameSpaces = CastUtils.cast((Map)def.getNamespaces());
                    for (Map.Entry ent : nameSpaces.entrySet()) {
                        String prefix = (String)ent.getKey();
                        String ns = (String)nameSpaces.get(prefix);
                        if ("".equals(prefix)) {
                            if (schemaElem.hasAttribute("xmlns")) continue;
                            Attr attr = schemaElem.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                            attr.setValue(ns);
                            schemaElem.setAttributeNodeNS(attr);
                            continue;
                        }
                        if (schemaElem.hasAttribute("xmlns:" + prefix)) continue;
                        String namespace = "http://www.w3.org/2000/xmlns/";
                        Attr attr = schemaElem.getOwnerDocument().createAttributeNS(namespace, "xmlns:" + prefix);
                        attr.setValue(ns);
                        schemaElem.setAttributeNodeNS(attr);
                    }
                    String systemId = def.getDocumentBaseURI() + "#types" + schemaCount;
                    schemaCol.setBaseUri(def.getDocumentBaseURI());
                    CatalogXmlSchemaURIResolver schemaResolver = new CatalogXmlSchemaURIResolver(this.bus);
                    schemaCol.setSchemaResolver((URIResolver)schemaResolver);
                    XmlSchema xmlSchema = schemaCol.read(schemaElem, systemId);
                    this.catalogResolved.putAll(schemaResolver.getResolvedMap());
                    SchemaInfo schemaInfo = new SchemaInfo(xmlSchema.getTargetNamespace());
                    schemaInfo.setSchema(xmlSchema);
                    schemaInfo.setSystemId(systemId);
                    schemaInfo.setElement(schemaElem);
                    schemaInfos.add(schemaInfo);
                    ++schemaCount;
                }
            }
        }
    }

    private void parseImports(Definition def, List<Definition> defList) {
        ArrayList importList = new ArrayList();
        Collection ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            if (defList.contains(impt.getDefinition())) continue;
            defList.add(impt.getDefinition());
            this.parseImports(impt.getDefinition(), defList);
        }
    }

    private void getSchemaList(Definition def) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            for (Object obj : typesElement.getExtensibilityElements()) {
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                this.addSchema(schema.getDocumentBaseURI(), schema);
            }
        }
    }

    private void addSchema(String docBaseURI, Schema schema) {
        List includes;
        String tns;
        Element schemaEle = schema.getElement();
        if (this.schemaList.get(docBaseURI) == null) {
            this.schemaList.put(docBaseURI, schemaEle);
        } else if (!(this.schemaList.get(docBaseURI) != null && this.schemaList.containsValue(schemaEle) || this.schemaList.get(tns = schema.getDocumentBaseURI() + "#" + schema.getElement().getAttribute("targetNamespace")) != null)) {
            this.schemaList.put(tns, schema.getElement());
        }
        Map imports = CastUtils.cast((Map)schema.getImports());
        if (imports != null && imports.size() > 0) {
            for (Map.Entry ent : imports.entrySet()) {
                String importNamespace = (String)ent.getKey();
                List schemaImports = CastUtils.cast((List)((List)imports.get(importNamespace)));
                for (SchemaImport schemaImport : schemaImports) {
                    Schema tempImport = schemaImport.getReferencedSchema();
                    String key = schemaImport.getSchemaLocationURI();
                    if (importNamespace == null && tempImport != null) {
                        importNamespace = tempImport.getDocumentBaseURI();
                    }
                    if (tempImport != null && !this.catalogResolved.containsKey(key)) {
                        key = tempImport.getDocumentBaseURI();
                    }
                    if (tempImport != null && !this.isSchemaParsed(key, importNamespace) && !this.schemaList.containsValue(tempImport.getElement())) {
                        this.addSchema(key, tempImport);
                    }
                    if (tempImport == null) continue;
                    this.inlineTransformer(key, tempImport.getElement(), schema.getElement(), false);
                }
            }
        }
        if ((includes = CastUtils.cast((List)schema.getIncludes())) != null && includes.size() > 0) {
            String includeNamespace = schema.getElement().getAttribute("targetNamespace");
            for (SchemaReference schemaInclude : includes) {
                Schema tempInclude = schemaInclude.getReferencedSchema();
                String key = tempInclude.getDocumentBaseURI();
                if (includeNamespace == null && tempInclude != null) {
                    includeNamespace = tempInclude.getDocumentBaseURI();
                }
                if (tempInclude != null && !this.catalogResolved.containsKey(key)) {
                    key = tempInclude.getDocumentBaseURI();
                }
                if (tempInclude != null && !this.isSchemaParsed(key, includeNamespace) && !this.schemaList.containsValue(tempInclude.getElement())) {
                    this.addSchema(key, tempInclude);
                }
                if (tempInclude == null) continue;
                this.inlineTransformer(key, tempInclude.getElement(), schema.getElement(), true);
            }
        }
    }

    private boolean isSchemaParsed(String baseUri, String ns) {
        Element ele;
        String tns;
        return this.schemaList.get(baseUri) != null && ns.equals(tns = (ele = this.schemaList.get(baseUri)).getAttribute("targetNamespace"));
    }

    private void inlineTransformer(String key, Element inlineSchema, Element outerSchema, boolean isInclude) {
        NodeList nl = null;
        nl = isInclude ? outerSchema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include") : outerSchema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int j = 0; j < nl.getLength(); ++j) {
            String schemaLocation = ((Element)nl.item(j)).getAttribute("schemaLocation");
            if (schemaLocation == null || !this.getXsdFileName(schemaLocation, "/").equals(this.getXsdFileName(key, "/"))) continue;
            outerSchema.removeChild(nl.item(j));
            for (int i = 0; i < inlineSchema.getChildNodes().getLength(); ++i) {
                outerSchema.appendChild(outerSchema.getOwnerDocument().importNode(inlineSchema.getChildNodes().item(i), true));
            }
            outerSchema.setPrefix("xs");
            outerSchema.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        }
    }

    private String getXsdFileName(String path, String sep) {
        String name = "";
        name = path.lastIndexOf(sep) >= 0 ? path.substring(path.lastIndexOf(sep) + 1) : path;
        return name;
    }
}

