/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.common.locks.LockManager;
import org.apache.servicemix.common.locks.impl.SimpleLockManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.executors.ExecutorAwareRunnable;
import org.apache.servicemix.vfs.FileObjectResolver;
import org.apache.servicemix.vfs.VFSEndpointType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSPollingEndpoint
extends PollingEndpoint
implements VFSEndpointType {
    private final Logger logger = LoggerFactory.getLogger(VFSPollingEndpoint.class);
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private FileObject file;
    private FileSelector selector;
    private Set<FileObject> workingSet = new CopyOnWriteArraySet<FileObject>();
    private boolean deleteFile = true;
    private boolean recursive = true;
    private String path;
    private Comparator<FileObject> comparator = null;
    private FileSystemManager fileSystemManager;
    private LockManager lockManager;
    private ConcurrentMap<String, InputStream> openExchanges = new ConcurrentHashMap<String, InputStream>();
    private boolean concurrentExchange = true;

    public VFSPollingEndpoint() {
    }

    public VFSPollingEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public VFSPollingEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public synchronized void start() throws Exception {
        super.start();
        this.workingSet.clear();
        this.openExchanges = new ConcurrentHashMap<String, InputStream>();
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        FileObject aFile;
        if (this.openExchanges.containsKey(exchange.getExchangeId())) {
            InputStream stream = (InputStream)this.openExchanges.get(exchange.getExchangeId());
            aFile = (FileObject)exchange.getMessage("in").getProperty("org.apache.servicemix.vfs");
            if (aFile == null) {
                throw new JBIException("Property org.apache.servicemix.vfs was removed from the exchange -- unable to delete/archive the file");
            }
            this.logger.debug("Releasing {}", (Object)aFile.getName().getPathDecoded());
            try {
                stream.close();
            }
            catch (IOException ex) {
                this.logger.error("Unable to close stream for file {}", (Object)aFile.getName().getPathDecoded(), (Object)ex);
            }
            try {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (this.isDeleteFile() && !aFile.delete()) {
                        throw new IOException("Could not delete file " + aFile.getName().getPathDecoded());
                    }
                } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    Exception e = exchange.getError();
                    if (e == null) {
                        throw new JBIException("Received an exchange with status ERROR, but no exception was set");
                    }
                    this.logger.warn("Message in file {} could not be handled successfully.", (Object)aFile.getName().getPathDecoded(), (Object)e);
                } else {
                    throw new JBIException("Unexpectedly received an exchange with status ACTIVE");
                }
                Object var6_6 = null;
                this.workingSet.remove(aFile);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.workingSet.remove(aFile);
                this.openExchanges.remove(exchange.getExchangeId());
                this.unlockAsyncFile(aFile);
                throw throwable;
            }
        }
        this.logger.debug("Received unknown exchange. Will be ignored...");
        return;
        this.openExchanges.remove(exchange.getExchangeId());
        this.unlockAsyncFile(aFile);
    }

    private void unlockAsyncFile(FileObject file) {
        String uri = file.getName().getURI().toString();
        Lock lock = this.lockManager.getLock(uri);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                this.logger.error("Can't release the lock.", (Throwable)ex);
            }
        }
    }

    public void poll() throws Exception {
        if (this.file == null) {
            try {
                this.file = FileObjectResolver.resolveToFileObject(this.getFileSystemManager(), this.getPath());
            }
            catch (Exception e) {
                this.logger.debug("Unable to resolve path: {}", (Object)this.getPath(), (Object)e);
                this.file = null;
            }
        }
        if (this.file != null) {
            this.file.close();
            this.pollFileOrDirectory(this.file);
        }
    }

    protected void pollFileOrDirectory(FileObject fileOrDirectory) throws Exception {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(FileObject fileOrDirectory, boolean processDir) throws Exception {
        if (fileOrDirectory.getType().equals(FileType.FILE)) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            this.logger.debug("Polling directory {}", (Object)fileOrDirectory.getName().getPathDecoded());
            FileObject[] files = null;
            files = this.selector != null ? this.sortPolledFiles(fileOrDirectory.findFiles(this.selector)) : this.sortPolledFiles(fileOrDirectory.getChildren());
            for (FileObject f : files) {
                this.pollFileOrDirectory(f, this.isRecursive());
            }
        } else {
            this.logger.debug("Skipping directory {}", (Object)fileOrDirectory.getName().getPathDecoded());
        }
    }

    private FileObject[] sortPolledFiles(FileObject[] files) {
        if (this.comparator == null) {
            return files;
        }
        Arrays.sort(files, this.comparator);
        return files;
    }

    protected void pollFile(final FileObject aFile) throws Exception {
        if (!this.isFullyAvailable(aFile)) {
            return;
        }
        if (this.workingSet.add(aFile)) {
            this.logger.debug("Scheduling file {} for processing.", (Object)aFile.getName().getPathDecoded());
            this.getExecutor().execute((Runnable)new ExecutorAwareRunnable(){

                public void run() {
                    String uri = aFile.getName().getURI().toString();
                    Lock lock = VFSPollingEndpoint.this.lockManager.getLock(uri);
                    if (lock.tryLock()) {
                        VFSPollingEndpoint.this.processFileNow(aFile);
                    } else {
                        VFSPollingEndpoint.this.workingSet.remove(aFile);
                        VFSPollingEndpoint.this.logger.debug("Unable to acquire lock on {}", (Object)aFile.getName().getURI());
                    }
                }

                public boolean shouldRunSynchronously() {
                    return !VFSPollingEndpoint.this.isConcurrentExchange();
                }
            });
        }
    }

    protected void processFileNow(FileObject aFile) {
        try {
            this.logger.debug("Processing file {}", (Object)aFile.getName().getURI());
            if (aFile.exists()) {
                this.processFile(aFile);
            }
        }
        catch (Exception e) {
            this.workingSet.remove(aFile);
            this.unlockAsyncFile(aFile);
            this.logger.error("Failed to process file: {}", (Object)aFile.getName().getURI(), (Object)e);
        }
    }

    protected void processFile(FileObject file) throws Exception {
        file.close();
        String name = file.getName().getURI();
        FileContent content = file.getContent();
        content.close();
        InputStream stream = content.getInputStream();
        if (stream == null) {
            throw new IOException("No input available for file!");
        }
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, stream, name);
        exchange.getInMessage().setProperty("org.apache.servicemix.vfs", (Object)file);
        this.openExchanges.put(exchange.getExchangeId(), stream);
        if (this.isConcurrentExchange()) {
            this.send((MessageExchange)exchange);
        } else {
            this.sendSync((MessageExchange)exchange);
            this.process((MessageExchange)exchange);
        }
    }

    private boolean isFullyAvailable(FileObject aFile) {
        block4: {
            try {
                if (aFile.getContent() == null) break block4;
                long size_old = aFile.getContent().getSize();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long size_new = aFile.getContent().getSize();
                return size_old == size_new;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setComparator(Comparator<FileObject> comparator) {
        this.comparator = comparator;
    }

    public Comparator<FileObject> getComparator() {
        return this.comparator;
    }

    public void setSelector(FileSelector selector) {
        this.selector = selector;
    }

    public FileSelector getSelector() {
        return this.selector;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public Set<FileObject> getWorkingSet() {
        return this.workingSet;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isConcurrentExchange() {
        return this.concurrentExchange;
    }

    public void setConcurrentExchange(boolean concurrentExchange) {
        this.concurrentExchange = concurrentExchange;
    }
}

