/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.apache.servicemix.wsn.EndpointManager;
import org.apache.servicemix.wsn.EndpointRegistrationException;
import org.apache.servicemix.wsn.component.WSNConfiguration;
import org.apache.servicemix.wsn.component.WSNDeployableEndpoint;
import org.apache.servicemix.wsn.component.WSNDeployer;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.jbi.JbiNotificationBroker;
import org.apache.servicemix.wsn.jms.JmsCreatePullPoint;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSNComponent
extends DefaultComponent {
    private static final String EMBEDDED_AMQ_BROKER_NAME = "smx_embedded";
    private WSDLFlattener flattener;
    private Map<QName, Document> descriptions;
    private JbiNotificationBroker notificationBroker;
    private JmsCreatePullPoint createPullPoint;
    private WSNConfiguration configuration = new WSNConfiguration();
    private ConnectionFactory connectionFactory;
    private Resource[] resources;
    private Object[] requests;
    private List<Endpoint> endpoints;
    private WSNDeployer deployer;
    private BrokerService brokerService;

    public WSNComponent() {
        this.serviceUnit = new DefaultServiceUnit((ServiceMixComponent)this);
    }

    public JbiNotificationBroker getNotificationBroker() {
        return this.notificationBroker;
    }

    public JmsCreatePullPoint getCreatePullPoint() {
        return this.createPullPoint;
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        this.deployer = new WSNDeployer((ServiceMixComponent)this);
        return new BaseServiceUnitManager((ServiceMixComponent)this, new Deployer[]{this.deployer});
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected List getConfiguredEndpoints() {
        return this.endpoints;
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{WSNEndpoint.class, WSNDeployableEndpoint.class};
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    public Object[] getRequests() {
        return this.requests;
    }

    public void setRequests(Object[] requests) {
        this.requests = requests;
    }

    protected void doInit() throws Exception {
        Endpoint ep;
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.load();
        this.notificationBroker = new JbiNotificationBroker(this.configuration.getBrokerName());
        this.notificationBroker.setManager(new WSNEndpointManager());
        if (this.connectionFactory == null) {
            try {
                this.connectionFactory = this.lookupConnectionFactory();
            }
            catch (Throwable t) {
                this.brokerService = new BrokerService();
                this.brokerService.setUseJmx(false);
                this.brokerService.setPersistent(false);
                this.brokerService.setBrokerName(EMBEDDED_AMQ_BROKER_NAME);
                this.brokerService.start();
                this.connectionFactory = new ActiveMQConnectionFactory("vm://smx_embedded");
            }
        }
        if (this.connectionFactory != null) {
            this.notificationBroker.setConnectionFactory(this.connectionFactory);
            this.notificationBroker.init();
        }
        this.createPullPoint = new JmsCreatePullPoint(this.configuration.getBrokerName());
        this.createPullPoint.setManager(new WSNEndpointManager());
        this.createPullPoint.setConnectionFactory(this.connectionFactory);
        this.createPullPoint.init();
        this.endpoints = new ArrayList<Endpoint>();
        if (this.resources != null) {
            for (int i = 0; i < this.resources.length; ++i) {
                ep = this.deployer.createEndpoint(this.resources[i].getURL());
                this.endpoints.add(ep);
            }
        }
        if (this.requests != null) {
            for (int i = 0; i < this.requests.length; ++i) {
                ep = this.deployer.createEndpoint(this.requests[i]);
                this.endpoints.add(ep);
            }
        }
        super.doInit();
    }

    protected void doShutDown() throws Exception {
        this.notificationBroker.destroy();
        this.createPullPoint.destroy();
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService = null;
        }
        super.doShutDown();
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        this.logger.debug("Querying service description for {}", (Object)endpoint);
        String key = EndpointSupport.getKey((ServiceEndpoint)endpoint);
        Endpoint ep = this.registry.getEndpoint(key);
        if (ep != null) {
            QName interfaceName = ep.getInterfaceName();
            if (interfaceName == null) {
                this.logger.debug("Could not retrieve description for endpoint {} (no interface defined)", (Object)key);
                return null;
            }
            return this.getDescription(interfaceName);
        }
        this.logger.debug("No endpoint found for {}", (Object)key);
        return null;
    }

    private synchronized Document getDescription(QName interfaceName) {
        try {
            Document doc;
            if (this.descriptions == null) {
                this.descriptions = new HashMap<QName, Document>();
            }
            if ((doc = this.descriptions.get(interfaceName)) == null) {
                if (this.flattener == null) {
                    final URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/servicemix/wsn/wsn.wsdl");
                    WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                    reader.setFeature("javax.wsdl.verbose", false);
                    Definition definition = reader.readWSDL(new WSDLLocator(){
                        private String last = null;

                        public InputSource getBaseInputSource() {
                            return new InputSource(resource.toString());
                        }

                        public InputSource getImportInputSource(String parentLocation, String importLocation) {
                            int idx = parentLocation.lastIndexOf(47);
                            this.last = parentLocation.substring(0, idx + 1) + importLocation;
                            return new InputSource(this.last);
                        }

                        public String getBaseURI() {
                            return resource.toString();
                        }

                        public String getLatestImportURI() {
                            return this.last;
                        }

                        public void close() {
                        }
                    });
                    this.flattener = new WSDLFlattener(definition);
                }
                Definition flatDef = this.flattener.getDefinition(interfaceName);
                doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(flatDef);
                this.descriptions.put(interfaceName, doc);
            }
            return doc;
        }
        catch (Exception e) {
            this.logger.debug("Error retrieving endpoint description", (Throwable)e);
            return null;
        }
    }

    protected ConnectionFactory lookupConnectionFactory() throws NamingException {
        Properties props = new Properties();
        if (this.configuration.getInitialContextFactory() != null && this.configuration.getJndiProviderURL() != null) {
            props.put("java.naming.factory.initial", this.configuration.getInitialContextFactory());
            props.put("java.naming.provider.url", this.configuration.getJndiProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        return (ConnectionFactory)ctx.lookup(this.configuration.getJndiConnectionFactoryName());
    }

    public class WSNEndpointManager
    implements EndpointManager {
        public Object register(String address, Object service) throws EndpointRegistrationException {
            try {
                WSNEndpoint endpoint = new WSNEndpoint(address, service);
                WSNComponent.this.addEndpoint((Endpoint)endpoint);
                return endpoint;
            }
            catch (Exception e) {
                throw new EndpointRegistrationException("Unable to activate endpoint", e);
            }
        }

        public void unregister(final Object endpoint) throws EndpointRegistrationException {
            WSNComponent.this.getExecutor(MessageExchange.Role.CONSUMER).execute(new Runnable(){

                public void run() {
                    try {
                        Endpoint ep = (Endpoint)endpoint;
                        WSNComponent.this.prepareShutdown(ep);
                        WSNComponent.this.removeEndpoint(ep);
                    }
                    catch (Exception e) {
                        WSNComponent.this.logger.error("Unable to deactivate endpoint", (Throwable)e);
                    }
                }
            });
        }
    }
}

