/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.cluster.engine.ClusterRegistration;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.util.MapToDictionary;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;

public class SimpleClusterRegistration
implements ClusterRegistration {
    private static final String SMX_COMMON_ENDPOINT_CLASS_NAME = "org.apache.servicemix.common.Endpoint";
    private Object endpoint;
    private QName interfaceName;
    private QName serviceName;
    private String endpointName;
    private String name;
    private String filter;
    private Endpoint nmrEndpoint;
    private transient Filter osgiFilter;

    public Object getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void init() throws Exception {
        if (this.endpoint instanceof Endpoint) {
            this.nmrEndpoint = (Endpoint)this.endpoint;
        }
        if (this.endpoint != null && this.implement(this.endpoint.getClass(), SMX_COMMON_ENDPOINT_CLASS_NAME)) {
            this.serviceName = (QName)this.invoke(this.endpoint, "getService");
            this.endpointName = (String)this.invoke(this.endpoint, "getEndpoint");
        }
        if (this.nmrEndpoint == null) {
            String f;
            ArrayList<String> filters = new ArrayList<String>();
            if (this.filter != null) {
                filters.add(this.filter);
            }
            if (this.interfaceName != null) {
                filters.add("INTERFACE_NAME=" + this.interfaceName.toString());
            }
            if (this.serviceName != null) {
                filters.add("SERVICE_NAME=" + this.serviceName.toString());
            }
            if (this.endpointName != null) {
                filters.add("ENDPOINT_NAME=" + this.endpointName);
            }
            if (this.name != null) {
                filters.add("NAME=" + this.name);
            }
            if (filters.isEmpty()) {
                throw new IllegalArgumentException("one field to match on must be set");
            }
            if (filters.size() == 1) {
                f = "(" + (String)filters.get(0) + ")";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("(&");
                for (String sf : filters) {
                    if (sf.startsWith("(")) {
                        sb.append(sf);
                        continue;
                    }
                    sb.append("(").append(sf).append(")");
                }
                sb.append(")");
                f = sb.toString();
            }
            this.osgiFilter = FrameworkUtil.createFilter((String)f);
        }
    }

    public boolean match(InternalEndpoint source) {
        if (this.nmrEndpoint != null) {
            return source.getEndpoint() == this.nmrEndpoint;
        }
        return this.osgiFilter.match((Dictionary)new MapToDictionary(source.getMetaData()));
    }

    private Object invoke(Object obj, String method) throws Exception {
        try {
            Method mth = obj.getClass().getMethod(method, new Class[0]);
            return mth.invoke(obj, new Object[0]);
        }
        catch (Throwable t) {
            throw new Exception("Could not invoke getter '" + method + "' on " + obj, t);
        }
    }

    private boolean implement(Class clz, String classOrInterface) {
        if (clz == null) {
            return false;
        }
        if (classOrInterface.equals(clz.getName())) {
            return true;
        }
        if (Object.class.equals((Object)clz)) {
            return false;
        }
        for (Class<?> itf : clz.getInterfaces()) {
            if (!this.implement(itf, classOrInterface)) continue;
            return true;
        }
        return this.implement(clz.getSuperclass(), classOrInterface);
    }
}

