/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.xml.ResultHandlerFactory;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class XsltComponent
extends ResourceBasedComponent {
    private XmlConverter xmlConverter;
    private URIResolver uriResolver;
    private boolean contentCache = true;

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean failOnNullBody;
        URIResolver resolver;
        final Resource resource = this.resolveMandatoryResource(remaining);
        this.log.debug("{} using schema resource: {}", (Object)this, (Object)resource);
        final XsltBuilder xslt = (XsltBuilder)this.getCamelContext().getInjector().newInstance(XsltBuilder.class);
        XmlConverter converter = (XmlConverter)this.resolveAndRemoveReferenceParameter(parameters, "converter", XmlConverter.class);
        if (converter == null) {
            converter = this.getXmlConverter();
        }
        if (converter != null) {
            xslt.setConverter(converter);
        }
        String transformerFactoryClassName = (String)this.getAndRemoveParameter(parameters, "transformerFactoryClass", String.class);
        TransformerFactory factory = null;
        if (transformerFactoryClassName != null) {
            Class factoryClass = this.getCamelContext().getClassResolver().resolveClass(transformerFactoryClassName, XsltComponent.class.getClassLoader());
            if (factoryClass != null) {
                factory = (TransformerFactory)this.getCamelContext().getInjector().newInstance(factoryClass);
            } else {
                this.log.warn("Cannot find the TransformerFactoryClass with the class name: " + transformerFactoryClassName);
            }
        }
        if (parameters.get("transformerFactory") != null) {
            factory = (TransformerFactory)this.resolveAndRemoveReferenceParameter(parameters, "transformerFactory", TransformerFactory.class);
        }
        if (factory != null) {
            xslt.getConverter().setTransformerFactory(factory);
        }
        if ((resolver = (URIResolver)this.resolveAndRemoveReferenceParameter(parameters, "uriResolver", URIResolver.class)) == null) {
            resolver = this.getUriResolver();
        }
        if (resolver == null) {
            resolver = new XsltUriResolver(this.getCamelContext().getClassResolver(), remaining);
        }
        xslt.setUriResolver(resolver);
        ResultHandlerFactory resultHandlerFactory = (ResultHandlerFactory)this.resolveAndRemoveReferenceParameter(parameters, "resultHandlerFactory", ResultHandlerFactory.class);
        if (resultHandlerFactory != null) {
            xslt.setResultHandlerFactory(resultHandlerFactory);
        }
        if ((failOnNullBody = (Boolean)this.getAndRemoveParameter(parameters, "failOnNullBody", Boolean.class)) != null) {
            xslt.setFailOnNullBody(failOnNullBody.booleanValue());
        }
        String output = (String)this.getAndRemoveParameter(parameters, "output", String.class);
        this.configureOutput(xslt, output);
        this.configureXslt(xslt, uri, remaining, parameters);
        this.loadResource(xslt, resource);
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        if (!cache) {
            return new ProcessorEndpoint(uri, (Component)this, (Processor)xslt){

                protected void onExchange(Exchange exchange) throws Exception {
                    XsltComponent.this.loadResource(xslt, resource);
                    super.onExchange(exchange);
                }
            };
        }
        return new ProcessorEndpoint(uri, (Component)this, (Processor)xslt);
    }

    private void loadResource(XsltBuilder xslt, Resource resource) throws TransformerConfigurationException {
        this.log.trace("{} loading schema resource: {}", (Object)this, (Object)resource);
        try {
            if (resource instanceof UrlResource) {
                File file = resource.getFile();
                if (file != null) {
                    if (!file.exists()) {
                        throw new FileNotFoundException("File: " + file + " not found.");
                    }
                    xslt.setTransformerFile(file);
                } else {
                    xslt.setTransformerURL(resource.getURL());
                }
            } else {
                xslt.setTransformerInputStream(resource.getInputStream());
            }
        }
        catch (Exception e) {
            throw new TransformerConfigurationException(e.getMessage() + " " + resource.toString(), e);
        }
    }

    protected void configureXslt(XsltBuilder xslt, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xslt, parameters);
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty((Object)output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }
}

