/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.audit.event.LogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;

public class ThreadedWorkingMemoryFileLogger
extends WorkingMemoryFileLogger {
    private int interval = 1000;
    private Writer writer;

    public ThreadedWorkingMemoryFileLogger(WorkingMemoryEventManager workingMemory) {
        super(workingMemory);
        this.setSplit(false);
    }

    public ThreadedWorkingMemoryFileLogger(KnowledgeRuntimeEventManager session) {
        super(session);
        this.setSplit(false);
    }

    public void start(int interval) {
        this.interval = interval;
        this.writer = new Writer();
        new Thread(this.writer).start();
    }

    public void stop() {
        this.writer.interrupt();
        this.writeToDisk();
    }

    public synchronized void logEventCreated(LogEvent logEvent) {
        super.logEventCreated(logEvent);
    }

    public synchronized void writeToDisk() {
        super.writeToDisk();
    }

    private class Writer
    implements Runnable {
        private boolean interrupt = false;

        private Writer() {
        }

        public void run() {
            while (!this.interrupt) {
                try {
                    Thread.sleep(ThreadedWorkingMemoryFileLogger.this.interval);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ThreadedWorkingMemoryFileLogger.this.writeToDisk();
            }
        }

        public void interrupt() {
            this.interrupt = true;
        }
    }
}

