/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.base.JavaFactRegistryEntry;
import org.drools.spi.JavaFact;

public class DelegateJavaFactHandler
implements JavaFact {
    private JavaFactRegistryEntry[] entries;

    public JavaFactRegistryEntry[] listWorkingMemories() {
        return this.entries;
    }

    public boolean register(WorkingMemory workingMemory) {
        int position;
        JavaFactRegistryEntry[] newEntries;
        if (workingMemory == null) {
            return false;
        }
        if (this.isRegistered(workingMemory)) {
            return false;
        }
        if (this.entries == null) {
            newEntries = new JavaFactRegistryEntry[1];
            position = 0;
        } else {
            int newLength = this.entries.length + 1;
            newEntries = new JavaFactRegistryEntry[newLength];
            System.arraycopy(this.entries, 0, newEntries, 0, newLength - 1);
            position = this.entries.length;
        }
        FactHandle handle = workingMemory.insert(this);
        newEntries[position] = new JavaFactRegistryEntry(workingMemory, handle);
        this.entries = newEntries;
        return true;
    }

    public void unregisterAll() {
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            WorkingMemory workingMemory = this.entries[i].getWorkingMemory();
            FactHandle handle = this.entries[i].getFactHandle();
            workingMemory.retract(handle);
        }
    }

    public boolean unregister(WorkingMemory workingMemory) {
        if (this.entries == null) {
            return false;
        }
        if (this.entries.length == 1 && this.entries[0].getWorkingMemory() == workingMemory) {
            this.entries = null;
            return true;
        }
        if (this.entries[0].getWorkingMemory() == workingMemory) {
            JavaFactRegistryEntry[] newEntries = new JavaFactRegistryEntry[this.entries.length - 1];
            System.arraycopy(this.entries, 1, newEntries, 0, newEntries.length);
            this.entries = newEntries;
            return true;
        }
        if (this.entries[this.entries.length - 1].getWorkingMemory() == workingMemory) {
            JavaFactRegistryEntry[] newEntries = new JavaFactRegistryEntry[this.entries.length - 1];
            System.arraycopy(this.entries, 0, newEntries, 0, newEntries.length);
            this.entries = newEntries;
            return true;
        }
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            if (this.entries[i].getWorkingMemory() != workingMemory) continue;
            JavaFactRegistryEntry[] newEntries = new JavaFactRegistryEntry[this.entries.length - 1];
            System.arraycopy(this.entries, 0, newEntries, 0, i);
            System.arraycopy(this.entries, i + 1, newEntries, i, newEntries.length - 1);
            this.entries = newEntries;
            return true;
        }
        return false;
    }

    public boolean isRegistered(WorkingMemory workingMemory) {
        if (this.entries == null) {
            return false;
        }
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            if (this.entries[i].getWorkingMemory() != workingMemory) continue;
            return true;
        }
        return false;
    }

    public int[] getChanges() {
        return null;
    }
}

