/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgenda;
import org.drools.core.util.LinkedListNode;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.time.JobHandle;

public class ScheduledAgendaItem
extends AgendaItem
implements Activation,
Externalizable,
LinkedListNode {
    private static final long serialVersionUID = 510L;
    private LinkedListNode previous;
    private LinkedListNode next;
    private InternalAgenda agenda;
    private JobHandle jobHandle;

    public ScheduledAgendaItem(long activationNumber, Tuple tuple, InternalAgenda agenda, PropagationContext context, Rule rule, GroupElement subrule) {
        super(activationNumber, tuple, 0, context, rule, subrule);
        this.agenda = agenda;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.previous = (LinkedListNode)in.readObject();
        this.next = (LinkedListNode)in.readObject();
        this.agenda = (InternalAgenda)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.previous);
        out.writeObject(this.agenda);
    }

    public LinkedListNode getNext() {
        return this.next;
    }

    public void setNext(LinkedListNode next) {
        this.next = next;
    }

    public LinkedListNode getPrevious() {
        return this.previous;
    }

    public void setPrevious(LinkedListNode previous) {
        this.previous = previous;
    }

    public void remove() {
        this.agenda.removeScheduleItem(this);
    }

    public JobHandle getJobHandle() {
        return this.jobHandle;
    }

    public void setJobHandle(JobHandle jobHandle) {
        this.jobHandle = jobHandle;
    }

    public String toString() {
        return "[ScheduledActivation rule=" + this.getRule().getName() + ", tuple=" + this.getTuple() + "]";
    }
}

