/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RuleSetNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new RuleSetNode();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (ruleFlowGroup != null && ruleFlowGroup.length() > 0) {
            ruleSetNode.setRuleFlowGroup(ruleFlowGroup);
        }
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("ruleSet", ruleSetNode, xmlDump, includeMeta);
        String ruleFlowGroup = ruleSetNode.getRuleFlowGroup();
        if (ruleFlowGroup != null) {
            xmlDump.append("ruleFlowGroup=\"" + ruleFlowGroup + "\" ");
        }
        if (ruleSetNode.getTimers() != null || includeMeta && this.containsMetaData(ruleSetNode)) {
            xmlDump.append(">\n");
            if (ruleSetNode.getTimers() != null) {
                this.writeTimers(ruleSetNode.getTimers(), xmlDump);
            }
            if (includeMeta) {
                this.writeMetaData(ruleSetNode, xmlDump);
            }
            this.endNode("ruleSet", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

